// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package discoveryengine provides access to the Discovery Engine API.
//
// For product documentation, see: https://cloud.google.com/discovery-engine/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/discoveryengine/v1"
//	...
//	ctx := context.Background()
//	discoveryengineService, err := discoveryengine.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package discoveryengine // import "google.golang.org/api/discoveryengine/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "discoveryengine:v1"
const apiName = "discoveryengine"
const apiVersion = "v1"
const basePath = "https://discoveryengine.googleapis.com/"
const basePathTemplate = "https://discoveryengine.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://discoveryengine.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Collections = NewProjectsLocationsCollectionsService(s)
	rs.DataStores = NewProjectsLocationsDataStoresService(s)
	rs.GroundingConfigs = NewProjectsLocationsGroundingConfigsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RankingConfigs = NewProjectsLocationsRankingConfigsService(s)
	rs.UserEvents = NewProjectsLocationsUserEventsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Collections *ProjectsLocationsCollectionsService

	DataStores *ProjectsLocationsDataStoresService

	GroundingConfigs *ProjectsLocationsGroundingConfigsService

	Operations *ProjectsLocationsOperationsService

	RankingConfigs *ProjectsLocationsRankingConfigsService

	UserEvents *ProjectsLocationsUserEventsService
}

func NewProjectsLocationsCollectionsService(s *Service) *ProjectsLocationsCollectionsService {
	rs := &ProjectsLocationsCollectionsService{s: s}
	rs.DataConnector = NewProjectsLocationsCollectionsDataConnectorService(s)
	rs.DataStores = NewProjectsLocationsCollectionsDataStoresService(s)
	rs.Engines = NewProjectsLocationsCollectionsEnginesService(s)
	rs.Operations = NewProjectsLocationsCollectionsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsService struct {
	s *Service

	DataConnector *ProjectsLocationsCollectionsDataConnectorService

	DataStores *ProjectsLocationsCollectionsDataStoresService

	Engines *ProjectsLocationsCollectionsEnginesService

	Operations *ProjectsLocationsCollectionsOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorService(s *Service) *ProjectsLocationsCollectionsDataConnectorService {
	rs := &ProjectsLocationsCollectionsDataConnectorService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataConnectorOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataConnectorService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataConnectorOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorOperationsService(s *Service) *ProjectsLocationsCollectionsDataConnectorOperationsService {
	rs := &ProjectsLocationsCollectionsDataConnectorOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataConnectorOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresService(s *Service) *ProjectsLocationsCollectionsDataStoresService {
	rs := &ProjectsLocationsCollectionsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsCollectionsDataStoresBranchesService(s)
	rs.CompletionSuggestions = NewProjectsLocationsCollectionsDataStoresCompletionSuggestionsService(s)
	rs.Controls = NewProjectsLocationsCollectionsDataStoresControlsService(s)
	rs.Conversations = NewProjectsLocationsCollectionsDataStoresConversationsService(s)
	rs.Models = NewProjectsLocationsCollectionsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsCollectionsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsDataStoresServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsCollectionsDataStoresSessionsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsCollectionsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsCollectionsDataStoresBranchesService

	CompletionSuggestions *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService

	Controls *ProjectsLocationsCollectionsDataStoresControlsService

	Conversations *ProjectsLocationsCollectionsDataStoresConversationsService

	Models *ProjectsLocationsCollectionsDataStoresModelsService

	Operations *ProjectsLocationsCollectionsDataStoresOperationsService

	Schemas *ProjectsLocationsCollectionsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsCollectionsDataStoresServingConfigsService

	Sessions *ProjectsLocationsCollectionsDataStoresSessionsService

	SiteSearchEngine *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsCollectionsDataStoresUserEventsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsCollectionsDataStoresBranchesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCompletionSuggestionsService(s *Service) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService {
	rs := &ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresControlsService(s *Service) *ProjectsLocationsCollectionsDataStoresControlsService {
	rs := &ProjectsLocationsCollectionsDataStoresControlsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresControlsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresConversationsService(s *Service) *ProjectsLocationsCollectionsDataStoresConversationsService {
	rs := &ProjectsLocationsCollectionsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresModelsOperationsService
}

func NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSchemasService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSchemasOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresServingConfigsService(s *Service) *ProjectsLocationsCollectionsDataStoresServingConfigsService {
	rs := &ProjectsLocationsCollectionsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSessionsService(s *Service) *ProjectsLocationsCollectionsDataStoresSessionsService {
	rs := &ProjectsLocationsCollectionsDataStoresSessionsService{s: s}
	rs.Answers = NewProjectsLocationsCollectionsDataStoresSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSessionsService struct {
	s *Service

	Answers *ProjectsLocationsCollectionsDataStoresSessionsAnswersService
}

func NewProjectsLocationsCollectionsDataStoresSessionsAnswersService(s *Service) *ProjectsLocationsCollectionsDataStoresSessionsAnswersService {
	rs := &ProjectsLocationsCollectionsDataStoresSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s)
	rs.TargetSites = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService

	TargetSites *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresUserEventsService(s *Service) *ProjectsLocationsCollectionsDataStoresUserEventsService {
	rs := &ProjectsLocationsCollectionsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesService(s *Service) *ProjectsLocationsCollectionsEnginesService {
	rs := &ProjectsLocationsCollectionsEnginesService{s: s}
	rs.Controls = NewProjectsLocationsCollectionsEnginesControlsService(s)
	rs.Conversations = NewProjectsLocationsCollectionsEnginesConversationsService(s)
	rs.Operations = NewProjectsLocationsCollectionsEnginesOperationsService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsEnginesServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsCollectionsEnginesSessionsService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesService struct {
	s *Service

	Controls *ProjectsLocationsCollectionsEnginesControlsService

	Conversations *ProjectsLocationsCollectionsEnginesConversationsService

	Operations *ProjectsLocationsCollectionsEnginesOperationsService

	ServingConfigs *ProjectsLocationsCollectionsEnginesServingConfigsService

	Sessions *ProjectsLocationsCollectionsEnginesSessionsService
}

func NewProjectsLocationsCollectionsEnginesControlsService(s *Service) *ProjectsLocationsCollectionsEnginesControlsService {
	rs := &ProjectsLocationsCollectionsEnginesControlsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesControlsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesConversationsService(s *Service) *ProjectsLocationsCollectionsEnginesConversationsService {
	rs := &ProjectsLocationsCollectionsEnginesConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesOperationsService(s *Service) *ProjectsLocationsCollectionsEnginesOperationsService {
	rs := &ProjectsLocationsCollectionsEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesServingConfigsService(s *Service) *ProjectsLocationsCollectionsEnginesServingConfigsService {
	rs := &ProjectsLocationsCollectionsEnginesServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesSessionsService(s *Service) *ProjectsLocationsCollectionsEnginesSessionsService {
	rs := &ProjectsLocationsCollectionsEnginesSessionsService{s: s}
	rs.Answers = NewProjectsLocationsCollectionsEnginesSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesSessionsService struct {
	s *Service

	Answers *ProjectsLocationsCollectionsEnginesSessionsAnswersService
}

func NewProjectsLocationsCollectionsEnginesSessionsAnswersService(s *Service) *ProjectsLocationsCollectionsEnginesSessionsAnswersService {
	rs := &ProjectsLocationsCollectionsEnginesSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsCollectionsOperationsService(s *Service) *ProjectsLocationsCollectionsOperationsService {
	rs := &ProjectsLocationsCollectionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresService(s *Service) *ProjectsLocationsDataStoresService {
	rs := &ProjectsLocationsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsDataStoresBranchesService(s)
	rs.CompletionSuggestions = NewProjectsLocationsDataStoresCompletionSuggestionsService(s)
	rs.Controls = NewProjectsLocationsDataStoresControlsService(s)
	rs.Conversations = NewProjectsLocationsDataStoresConversationsService(s)
	rs.Models = NewProjectsLocationsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsDataStoresServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsDataStoresSessionsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsDataStoresBranchesService

	CompletionSuggestions *ProjectsLocationsDataStoresCompletionSuggestionsService

	Controls *ProjectsLocationsDataStoresControlsService

	Conversations *ProjectsLocationsDataStoresConversationsService

	Models *ProjectsLocationsDataStoresModelsService

	Operations *ProjectsLocationsDataStoresOperationsService

	Schemas *ProjectsLocationsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsDataStoresServingConfigsService

	Sessions *ProjectsLocationsDataStoresSessionsService

	SiteSearchEngine *ProjectsLocationsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsDataStoresUserEventsService
}

func NewProjectsLocationsDataStoresBranchesService(s *Service) *ProjectsLocationsDataStoresBranchesService {
	rs := &ProjectsLocationsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsDataStoresBranchesOperationsService
}

func NewProjectsLocationsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresCompletionSuggestionsService(s *Service) *ProjectsLocationsDataStoresCompletionSuggestionsService {
	rs := &ProjectsLocationsDataStoresCompletionSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresCompletionSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresControlsService(s *Service) *ProjectsLocationsDataStoresControlsService {
	rs := &ProjectsLocationsDataStoresControlsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresControlsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresConversationsService(s *Service) *ProjectsLocationsDataStoresConversationsService {
	rs := &ProjectsLocationsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresModelsService(s *Service) *ProjectsLocationsDataStoresModelsService {
	rs := &ProjectsLocationsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsDataStoresModelsOperationsService
}

func NewProjectsLocationsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresOperationsService(s *Service) *ProjectsLocationsDataStoresOperationsService {
	rs := &ProjectsLocationsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSchemasService(s *Service) *ProjectsLocationsDataStoresSchemasService {
	rs := &ProjectsLocationsDataStoresSchemasService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSchemasService struct {
	s *Service
}

func NewProjectsLocationsDataStoresServingConfigsService(s *Service) *ProjectsLocationsDataStoresServingConfigsService {
	rs := &ProjectsLocationsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSessionsService(s *Service) *ProjectsLocationsDataStoresSessionsService {
	rs := &ProjectsLocationsDataStoresSessionsService{s: s}
	rs.Answers = NewProjectsLocationsDataStoresSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsDataStoresSessionsService struct {
	s *Service

	Answers *ProjectsLocationsDataStoresSessionsAnswersService
}

func NewProjectsLocationsDataStoresSessionsAnswersService(s *Service) *ProjectsLocationsDataStoresSessionsAnswersService {
	rs := &ProjectsLocationsDataStoresSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineService{s: s}
	rs.TargetSites = NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineService struct {
	s *Service

	TargetSites *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresUserEventsService(s *Service) *ProjectsLocationsDataStoresUserEventsService {
	rs := &ProjectsLocationsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsGroundingConfigsService(s *Service) *ProjectsLocationsGroundingConfigsService {
	rs := &ProjectsLocationsGroundingConfigsService{s: s}
	return rs
}

type ProjectsLocationsGroundingConfigsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRankingConfigsService(s *Service) *ProjectsLocationsRankingConfigsService {
	rs := &ProjectsLocationsRankingConfigsService{s: s}
	return rs
}

type ProjectsLocationsRankingConfigsService struct {
	s *Service
}

func NewProjectsLocationsUserEventsService(s *Service) *ProjectsLocationsUserEventsService {
	rs := &ProjectsLocationsUserEventsService{s: s}
	return rs
}

type ProjectsLocationsUserEventsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON, such as
// raw binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorContext: A description of the context
// in which an error occurred.
type GoogleCloudDiscoveryengineLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudDiscoveryengineLoggingHttpRequestContext `json:"httpRequest,omitempty"`
	// ReportLocation: The location in the source code where the decision was made
	// to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudDiscoveryengineLoggingSourceLocation `json:"reportLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpRequest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorLog: An error log which is reported to
// the Error Reporting system.
type GoogleCloudDiscoveryengineLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudDiscoveryengineLoggingErrorContext `json:"context,omitempty"`
	// ImportPayload: The error payload that is populated on LRO import APIs.
	ImportPayload *GoogleCloudDiscoveryengineLoggingImportErrorContext `json:"importPayload,omitempty"`
	// Message: A message describing the error.
	Message string `json:"message,omitempty"`
	// RequestPayload: The API request payload, represented as a protocol buffer.
	// Most API request types are supported—for example: *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.DocumentService.Cre
	// ateDocumentRequest` *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.UserEventService.Wr
	// iteUserEventRequest`
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`
	// ResponsePayload: The API response payload, represented as a protocol buffer.
	// This is used to log some "soft errors", where the response is valid but we
	// consider there are some quality issues like unjoined events. The following
	// API responses are supported, and no PII is included: *
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend` *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEvent` *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEvent`
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`
	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudDiscoveryengineLoggingServiceContext `json:"serviceContext,omitempty"`
	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorLog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingHttpRequestContext: HTTP request data that
// is related to a reported error.
type GoogleCloudDiscoveryengineLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResponseStatusCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingHttpRequestContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingImportErrorContext: The error payload that
// is populated on LRO import APIs, including the following: *
// `google.cloud.discoveryengine.v1alpha.DocumentService.ImportDocuments` *
// `google.cloud.discoveryengine.v1alpha.UserEventService.ImportUserEvents`
type GoogleCloudDiscoveryengineLoggingImportErrorContext struct {
	// Document: The detailed content which caused the error on importing a
	// document.
	Document string `json:"document,omitempty"`
	// GcsPath: Google Cloud Storage file path of the import source. Can be set for
	// batch operation error.
	GcsPath string `json:"gcsPath,omitempty"`
	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`
	// Operation: The operation resource name of the LRO.
	Operation string `json:"operation,omitempty"`
	// UserEvent: The detailed content which caused the error on importing a user
	// event.
	UserEvent string `json:"userEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingImportErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingServiceContext: Describes a running service
// that sends errors.
type GoogleCloudDiscoveryengineLoggingServiceContext struct {
	// Service: An identifier of the service—for example,
	// `discoveryengine.googleapis.com`.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingServiceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingSourceLocation: Indicates a location in the
// source code of the service for which errors are reported.
type GoogleCloudDiscoveryengineLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method—for example,
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`.
	FunctionName string `json:"functionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingSourceLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AlloyDbSource: AlloyDB source import data from.
type GoogleCloudDiscoveryengineV1AlloyDbSource struct {
	// ClusterId: Required. The AlloyDB cluster to copy the data from with a length
	// limit of 256 characters.
	ClusterId string `json:"clusterId,omitempty"`
	// DatabaseId: Required. The AlloyDB database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the AlloyDB export to a specific Cloud Storage directory. Ensure that the
	// AlloyDB service account has the necessary Cloud Storage Admin permissions to
	// access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// LocationId: Required. The AlloyDB location to copy the data from with a
	// length limit of 256 characters.
	LocationId string `json:"locationId,omitempty"`
	// ProjectId: The project ID that the AlloyDB source is in with a length limit
	// of 128 characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The AlloyDB table to copy the data from with a length
	// limit of 256 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AlloyDbSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AlloyDbSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Answer: Defines an answer.
type GoogleCloudDiscoveryengineV1Answer struct {
	// AnswerSkippedReasons: Additional answer-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "ANSWER_SKIPPED_REASON_UNSPECIFIED" - Default value. The answer skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED" - The non-answer seeking query ignored
	// case.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the answer if there are no high-relevance search results.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the answer if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// answer if there is no relevant content in the retrieved search results.
	AnswerSkippedReasons []string `json:"answerSkippedReasons,omitempty"`
	// AnswerText: The textual answer.
	AnswerText string `json:"answerText,omitempty"`
	// Citations: Citations.
	Citations []*GoogleCloudDiscoveryengineV1AnswerCitation `json:"citations,omitempty"`
	// CompleteTime: Output only. Answer completed timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Answer creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*/answers/*`
	Name string `json:"name,omitempty"`
	// QueryUnderstandingInfo: Query understanding information.
	QueryUnderstandingInfo *GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo `json:"queryUnderstandingInfo,omitempty"`
	// References: References.
	References []*GoogleCloudDiscoveryengineV1AnswerReference `json:"references,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// State: The state of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Answer generation is currently in progress.
	//   "FAILED" - Answer generation currently failed.
	//   "SUCCEEDED" - Answer generation has succeeded.
	State string `json:"state,omitempty"`
	// Steps: Answer generation steps.
	Steps []*GoogleCloudDiscoveryengineV1AnswerStep `json:"steps,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnswerSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Answer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Answer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerCitation: Citation info for a segment.
type GoogleCloudDiscoveryengineV1AnswerCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1AnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in bytes
	// (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerCitationSource: Citation source.
type GoogleCloudDiscoveryengineV1AnswerCitationSource struct {
	// ReferenceId: ID of the citation source.
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequest: Request message for
// ConversationalSearchService.AnswerQuery method.
type GoogleCloudDiscoveryengineV1AnswerQueryRequest struct {
	// AnswerGenerationSpec: Answer generation specification.
	AnswerGenerationSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec `json:"answerGenerationSpec,omitempty"`
	// AsynchronousMode: Asynchronous mode control. If enabled, the response will
	// be returned with answer/session resource name without final answer. The API
	// users need to do the polling to get the latest status of answer/session by
	// calling ConversationalSearchService.GetAnswer or
	// ConversationalSearchService.GetSession method.
	AsynchronousMode bool `json:"asynchronousMode,omitempty"`
	// Query: Required. Current user query.
	Query *GoogleCloudDiscoveryengineV1Query `json:"query,omitempty"`
	// QueryUnderstandingSpec: Query understanding specification.
	QueryUnderstandingSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec `json:"queryUnderstandingSpec,omitempty"`
	// RelatedQuestionsSpec: Related questions specification.
	RelatedQuestionsSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec `json:"relatedQuestionsSpec,omitempty"`
	// SafetySpec: Model specification.
	SafetySpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec `json:"safetySpec,omitempty"`
	// SearchSpec: Search specification.
	SearchSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec `json:"searchSpec,omitempty"`
	// Session: The session resource name. Not required. When session field is not
	// set, the API is in sessionless mode. We support auto session mode: users can
	// use the wildcard symbol `-` as session ID. A new ID will be automatically
	// generated and assigned.
	Session string `json:"session,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. The field must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationSpec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec: Answer
// generation specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec struct {
	// AnswerLanguageCode: Language code for Answer. Use language tags defined by
	// BCP47 (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	AnswerLanguageCode string `json:"answerLanguageCode,omitempty"`
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No answer is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating answers for adversarial queries and return fallback messages
	// instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. If this field is set to `false`, all search results are used
	// regardless of relevance to generate answers. If set to `true` or unset, the
	// behavior will be determined automatically by the service.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonAnswerSeekingQuery: Specifies whether to filter out queries that
	// are not answer-seeking. The default value is `false`. Google employs
	// search-query classification to detect answer-seeking queries. No answer is
	// returned if the search query is classified as a non-answer seeking query. If
	// this field is set to `true`, we skip generating answers for non-answer
	// seeking queries and return fallback messages instead.
	IgnoreNonAnswerSeekingQuery bool `json:"ignoreNonAnswerSeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citation metadata in the
	// answer. The default value is `false`.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// ModelSpec: Answer generation model specification.
	ModelSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec `json:"modelSpec,omitempty"`
	// PromptSpec: Answer generation prompt specification.
	PromptSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec `json:"promptSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec:
// Answer Generation Model specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec struct {
	// ModelVersion: Model version. If not set, it will use the default stable
	// model. Allowed values are: stable, preview.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec:
//
//	Answer generation prompt specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec struct {
	// Preamble: Customized preamble.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec: Query
// understanding specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec struct {
	// QueryClassificationSpec: Query classification specification.
	QueryClassificationSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec `json:"queryClassificationSpec,omitempty"`
	// QueryRephraserSpec: Query rephraser specification.
	QueryRephraserSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec `json:"queryRephraserSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationSpec") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClas
// sificationSpec: Query classification specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec struct {
	// Types: Enabled query classification types.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Types") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Types") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryReph
// raserSpec: Query rephraser specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec struct {
	// Disable: Disable query rephraser.
	Disable bool `json:"disable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec: Related
// questions specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec struct {
	// Enable: Enable related questions feature if true.
	Enable bool `json:"enable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec: Safety
// specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec struct {
	// Enable: Enable the safety filtering on the answer response. It is false by
	// default.
	Enable bool `json:"enable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec: Search
// specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec struct {
	// SearchParams: Search parameters.
	SearchParams *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams `json:"searchParams,omitempty"`
	// SearchResultList: Search result list.
	SearchResultList *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList `json:"searchResultList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams: Search
// parameters.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams struct {
	// BoostSpec: Boost specification to boost certain documents in search results
	// which may affect the answer query response. For more information on
	// boosting, see Boosting (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// DataStoreSpecs: Specs defining dataStores to filter on in a search call and
	// configurations for those dataStores. This is only considered for engines
	// with multiple dataStores use case. For single dataStore within an engine,
	// they should use the specs at the top level.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. This will be used to filter
	// search results which may affect the Answer response. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customers might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// MaxReturnResults: Number of search results to return. The default value is
	// 10.
	MaxReturnResults int64 `json:"maxReturnResults,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering,
	// see Ordering (https://cloud.google.com/retail/docs/filter-and-order#order)
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode is based on
	// DataStore.DocumentProcessingConfig.chunking_config: * If
	// DataStore.DocumentProcessingConfig.chunking_config is specified, it defaults
	// to `CHUNKS`. * Otherwise, it defaults to `DOCUMENTS`. See parse and chunk
	// documents
	// (https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DataStore.DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList:
// Search result list.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList struct {
	// SearchResults: Search results.
	SearchResults []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResult: Search result.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultChunkInfo: Chunk information.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfo: Unstructured document information.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// DocumentContexts: List of document contexts.
	DocumentContexts []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext `json:"documentContexts,omitempty"`
	// ExtractiveAnswers: List of extractive answers.
	ExtractiveAnswers []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer `json:"extractiveAnswers,omitempty"`
	// ExtractiveSegments: List of extractive segments.
	ExtractiveSegments []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment `json:"extractiveSegments,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfoDocumentContext: Document context.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext struct {
	// Content: Document content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfoExtractiveAnswer: Extractive answer. Guide
// (https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer struct {
	// Content: Extractive answer content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfoExtractiveSegment: Extractive segment. Guide
// (https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments)
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment struct {
	// Content: Extractive segment content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryResponse: Response message for
// ConversationalSearchService.AnswerQuery method.
type GoogleCloudDiscoveryengineV1AnswerQueryResponse struct {
	// Answer: Answer resource object. If
	// AnswerQueryRequest.StepSpec.max_step_count is greater than 1, use
	// Answer.name to fetch answer information using
	// ConversationalSearchService.GetAnswer API.
	Answer *GoogleCloudDiscoveryengineV1Answer `json:"answer,omitempty"`
	// AnswerQueryToken: A global unique ID used for logging.
	AnswerQueryToken string `json:"answerQueryToken,omitempty"`
	// Session: Session resource object. It will be only available when session
	// field is set and valid in the AnswerQueryRequest request.
	Session *GoogleCloudDiscoveryengineV1Session `json:"session,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo: Query
// understanding information.
type GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo struct {
	// QueryClassificationInfo: Query classification information.
	QueryClassificationInfo []*GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo `json:"queryClassificationInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationIn
// fo: Query classification information.
type GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo struct {
	// Positive: Classification output.
	Positive bool `json:"positive,omitempty"`
	// Type: Query classification type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Positive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Positive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReference: Reference.
type GoogleCloudDiscoveryengineV1AnswerReference struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo `json:"chunkInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo: Chunk information.
type GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// RelevanceScore: Relevance score.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata:
// Document metadata.
type GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo:
// Unstructured document information.
type GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent `json:"chunkContents,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkConte
// nt: Chunk content.
type GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStep: Step information.
type GoogleCloudDiscoveryengineV1AnswerStep struct {
	// Actions: Actions.
	Actions []*GoogleCloudDiscoveryengineV1AnswerStepAction `json:"actions,omitempty"`
	// Description: The description of the step.
	Description string `json:"description,omitempty"`
	// State: The state of the step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Step is currently in progress.
	//   "FAILED" - Step currently failed.
	//   "SUCCEEDED" - Step has succeeded.
	State string `json:"state,omitempty"`
	// Thought: The thought of the step.
	Thought string `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepAction: Action.
type GoogleCloudDiscoveryengineV1AnswerStepAction struct {
	// Observation: Observation.
	Observation *GoogleCloudDiscoveryengineV1AnswerStepActionObservation `json:"observation,omitempty"`
	// SearchAction: Search action.
	SearchAction *GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction `json:"searchAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Observation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Observation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepActionObservation: Observation.
type GoogleCloudDiscoveryengineV1AnswerStepActionObservation struct {
	// SearchResults: Search results observed by the search action, it can be
	// snippets info or chunk info, depending on the citation type set by the user.
	SearchResults []*GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult struct {
	// ChunkInfo: If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// SnippetInfo: If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo `json:"snippetInfo,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It's populated from the struct data from the Document (code pointer:
	// http://shortn/_objzAfIiHq), or the Chunk in search result (code pointer:
	// http://shortn/_Ipo6KFFGBL).
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo:
//
//	Chunk information.
type GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// RelevanceScore: Relevance score.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInf
// o: Snippet information.
type GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo struct {
	// Snippet: Snippet content.
	Snippet string `json:"snippet,omitempty"`
	// SnippetStatus: Status of the snippet defined by the search team.
	SnippetStatus string `json:"snippetStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction: Search action.
type GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction struct {
	// Query: The query to search.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.BatchCreateTargetSites
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest: Request message
// for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest struct {
	// Requests: Required. The request message specifying the resources to create.
	// A maximum of 20 TargetSites can be created in a batch.
	Requests []*GoogleCloudDiscoveryengineV1CreateTargetSiteRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse: Response message
// for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest: Request message
// for SiteSearchEngineService.BatchVerifyTargetSites method.
type GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest struct {
}

// GoogleCloudDiscoveryengineV1BigQuerySource: BigQuery source import data
// from.
type GoogleCloudDiscoveryengineV1BigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for user event imports: * `user_event` (default): One
	// UserEvent per row. Supported values for document imports: * `document`
	// (default): One Document format per row. Each document must have a valid
	// Document.id and one of Document.json_data or Document.struct_data. *
	// `custom`: One custom data per row in arbitrary format that conforms to the
	// defined Schema of the data store. This can only be used by the GENERIC Data
	// Store vertical.
	DataSchema string `json:"dataSchema,omitempty"`
	// DatasetId: Required. The BigQuery data set to copy the data from with a
	// length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`
	// ProjectId: The project ID (can be project # or ID) that the BigQuery source
	// is in with a length limit of 128 characters. If not specified, inherits the
	// project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The BigQuery table to copy the data from with a length
	// limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableOptions: The Bigtable Options object
// that contains information to support the import.
type GoogleCloudDiscoveryengineV1BigtableOptions struct {
	// Families: The mapping from family names to an object that contains column
	// families level information for the given column family. If a family is not
	// present in this map it will be ignored.
	Families map[string]GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily `json:"families,omitempty"`
	// KeyFieldName: The field name used for saving row key value in the document.
	// The name has to match the pattern `a-zA-Z0-9*`.
	KeyFieldName string `json:"keyFieldName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Families") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Families") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn: The column of the
// Bigtable.
type GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn struct {
	// Encoding: The encoding mode of the values when the type is not `STRING`.
	// Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric
	// text strings. * `BINARY`: indicates values are encoded using `HBase
	// Bytes.toBytes` family of functions. This can be overridden for a specific
	// column by listing that column in `columns` and specifying an encoding for
	// it.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - The encoding is unspecified.
	//   "TEXT" - Text encoding.
	//   "BINARY" - Binary encoding.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: The field name to use for this column in the document. The name
	// has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from the
	// qualifier bytes with best effort. However, due to different naming patterns,
	// field name collisions could happen, where parsing behavior is undefined.
	FieldName string `json:"fieldName,omitempty"`
	// Qualifier: Required. Qualifier of the column. If it cannot be decoded with
	// utf-8, use a base-64 encoded string instead.
	Qualifier string `json:"qualifier,omitempty"`
	// Type: The type of values in this column family. The values are expected to
	// be encoded using `HBase Bytes.toBytes` function when the encoding value is
	// set to `BINARY`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "STRING" - String type.
	//   "NUMBER" - Numerical type.
	//   "INTEGER" - Integer type.
	//   "VAR_INTEGER" - Variable length integer type.
	//   "BIG_NUMERIC" - BigDecimal type.
	//   "BOOLEAN" - Boolean type.
	//   "JSON" - JSON type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily: The column
// family of the Bigtable.
type GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily struct {
	// Columns: The list of objects that contains column level information for each
	// column. If a column is not present in this list it will be ignored.
	Columns []*GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn `json:"columns,omitempty"`
	// Encoding: The encoding mode of the values when the type is not STRING.
	// Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric
	// text strings. * `BINARY`: indicates values are encoded using `HBase
	// Bytes.toBytes` family of functions. This can be overridden for a specific
	// column by listing that column in `columns` and specifying an encoding for
	// it.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - The encoding is unspecified.
	//   "TEXT" - Text encoding.
	//   "BINARY" - Binary encoding.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: The field name to use for this column family in the document. The
	// name has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from
	// the family name with best effort. However, due to different naming patterns,
	// field name collisions could happen, where parsing behavior is undefined.
	FieldName string `json:"fieldName,omitempty"`
	// Type: The type of values in this column family. The values are expected to
	// be encoded using `HBase Bytes.toBytes` function when the encoding value is
	// set to `BINARY`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "STRING" - String type.
	//   "NUMBER" - Numerical type.
	//   "INTEGER" - Integer type.
	//   "VAR_INTEGER" - Variable length integer type.
	//   "BIG_NUMERIC" - BigDecimal type.
	//   "BOOLEAN" - Boolean type.
	//   "JSON" - JSON type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableSource: The Cloud Bigtable source for
// importing data.
type GoogleCloudDiscoveryengineV1BigtableSource struct {
	// BigtableOptions: Required. Bigtable options that contains information needed
	// when parsing data into typed structures. For example, column type
	// annotations.
	BigtableOptions *GoogleCloudDiscoveryengineV1BigtableOptions `json:"bigtableOptions,omitempty"`
	// InstanceId: Required. The instance ID of the Cloud Bigtable that needs to be
	// imported.
	InstanceId string `json:"instanceId,omitempty"`
	// ProjectId: The project ID that the Bigtable source is in with a length limit
	// of 128 characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The table ID of the Cloud Bigtable that needs to be
	// imported.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigtableOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigtableOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CheckGroundingRequest: Request message for
// GroundedGenerationService.CheckGrounding method.
type GoogleCloudDiscoveryengineV1CheckGroundingRequest struct {
	// AnswerCandidate: Answer candidate to check. Can have a maximum length of
	// 1024 characters.
	AnswerCandidate string `json:"answerCandidate,omitempty"`
	// Facts: List of facts for the grounding check. We support up to 200 facts.
	Facts []*GoogleCloudDiscoveryengineV1GroundingFact `json:"facts,omitempty"`
	// GroundingSpec: Configuration of the grounding check.
	GroundingSpec *GoogleCloudDiscoveryengineV1CheckGroundingSpec `json:"groundingSpec,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCandidate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCandidate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CheckGroundingResponse: Response message for the
// GroundedGenerationService.CheckGrounding method.
type GoogleCloudDiscoveryengineV1CheckGroundingResponse struct {
	// CitedChunks: List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedChunks []*GoogleCloudDiscoveryengineV1FactChunk `json:"citedChunks,omitempty"`
	// Claims: Claim texts and citation info across all claims in the answer
	// candidate.
	Claims []*GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim `json:"claims,omitempty"`
	// SupportScore: The support score for the input answer candidate. Higher the
	// score, higher is the fraction of claims that are supported by the provided
	// facts. This is always set when a response is returned.
	SupportScore float64 `json:"supportScore,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CitedChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitedChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CheckGroundingResponse) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponse
	var s1 struct {
		SupportScore gensupport.JSONFloat64 `json:"supportScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SupportScore = float64(s1.SupportScore)
	return nil
}

// GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim: Text and citation
// info for a claim in the answer candidate.
type GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim struct {
	// CitationIndices: A list of indices (into 'cited_chunks') specifying the
	// citations associated with the claim. For instance [1,3,4] means that
	// cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
	// supporting for the claim. A citation to a fact indicates that the claim is
	// supported by the fact.
	CitationIndices []int64 `json:"citationIndices,omitempty"`
	// ClaimText: Text for the claim in the answer candidate. Always provided
	// regardless of whether citations or anti-citations are found.
	ClaimText string `json:"claimText,omitempty"`
	// EndPos: Position indicating the end of the claim in the answer candidate,
	// exclusive.
	EndPos int64 `json:"endPos,omitempty"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim doesn't require attribution/grounding
	// check, this field will be set to false. In that case, no grounding check was
	// done for the claim and therefore citation_indices, and anti_citation_indices
	// should not be returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// StartPos: Position indicating the start of the claim in the answer
	// candidate, measured in bytes.
	StartPos int64 `json:"startPos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIndices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIndices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CheckGroundingSpec: Specification for the
// grounding check.
type GoogleCloudDiscoveryengineV1CheckGroundingSpec struct {
	// CitationThreshold: The threshold (in [0,1]) used for determining whether a
	// fact must be cited for a claim in the answer candidate. Choosing a higher
	// threshold will lead to fewer but very strong citations, while choosing a
	// lower threshold may lead to more but somewhat weaker citations. If unset,
	// the threshold will default to 0.6.
	CitationThreshold float64 `json:"citationThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CheckGroundingSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingSpec
	var s1 struct {
		CitationThreshold gensupport.JSONFloat64 `json:"citationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CitationThreshold = float64(s1.CitationThreshold)
	return nil
}

// GoogleCloudDiscoveryengineV1Chunk: Chunk captures all raw metadata
// information of items to be recommended or searched in the chunk mode.
type GoogleCloudDiscoveryengineV1Chunk struct {
	// ChunkMetadata: Output only. Metadata of the current chunk.
	ChunkMetadata *GoogleCloudDiscoveryengineV1ChunkChunkMetadata `json:"chunkMetadata,omitempty"`
	// Content: Content is a string from a document (parsed content).
	Content string `json:"content,omitempty"`
	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It contains
	// derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`
	// DocumentMetadata: Metadata of the document from the current chunk.
	DocumentMetadata *GoogleCloudDiscoveryengineV1ChunkDocumentMetadata `json:"documentMetadata,omitempty"`
	// Id: Unique chunk ID of the current chunk.
	Id string `json:"id,omitempty"`
	// Name: The full resource name of the chunk. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`
	// PageSpan: Page span of the chunk.
	PageSpan *GoogleCloudDiscoveryengineV1ChunkPageSpan `json:"pageSpan,omitempty"`
	// RelevanceScore: Output only. Represents the relevance score based on
	// similarity. Higher score indicates higher chunk relevance. The score is in
	// range [-1.0, 1.0]. Only populated on SearchService.SearchResponse.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkMetadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Chunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Chunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1Chunk) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1Chunk
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1ChunkChunkMetadata: Metadata of the current
// chunk. This field is only populated on SearchService.Search API.
type GoogleCloudDiscoveryengineV1ChunkChunkMetadata struct {
	// NextChunks: The next chunks of the current chunk. The number is controlled
	// by SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks. This field is
	// only populated on SearchService.Search API.
	NextChunks []*GoogleCloudDiscoveryengineV1Chunk `json:"nextChunks,omitempty"`
	// PreviousChunks: The previous chunks of the current chunk. The number is
	// controlled by SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks.
	// This field is only populated on SearchService.Search API.
	PreviousChunks []*GoogleCloudDiscoveryengineV1Chunk `json:"previousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkChunkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkChunkMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ChunkDocumentMetadata: Document metadata
// contains the information of the document of the current chunk.
type GoogleCloudDiscoveryengineV1ChunkDocumentMetadata struct {
	// StructData: Data representation. The structured JSON data for the document.
	// It should conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Uri of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ChunkPageSpan: Page span of the chunk.
type GoogleCloudDiscoveryengineV1ChunkPageSpan struct {
	// PageEnd: The end page of the chunk.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: The start page of the chunk.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CloudSqlSource: Cloud SQL source import data
// from.
type GoogleCloudDiscoveryengineV1CloudSqlSource struct {
	// DatabaseId: Required. The Cloud SQL database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the Cloud SQL export to a specific Cloud Storage directory. Ensure that the
	// Cloud SQL service account has the necessary Cloud Storage Admin permissions
	// to access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// InstanceId: Required. The Cloud SQL instance to copy the data from with a
	// length limit of 256 characters.
	InstanceId string `json:"instanceId,omitempty"`
	// Offload: Option for serverless export. Enabling this option will incur
	// additional cost. More info can be found here
	// (https://cloud.google.com/sql/pricing#serverless).
	Offload bool `json:"offload,omitempty"`
	// ProjectId: The project ID that the Cloud SQL source is in with a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The Cloud SQL table to copy the data from with a length
	// limit of 256 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CloudSqlSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CloudSqlSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompleteQueryResponse: Response message for
// CompletionService.CompleteQuery method.
type GoogleCloudDiscoveryengineV1CompleteQueryResponse struct {
	// QuerySuggestions: Results of the matched query suggestions. The result list
	// is ordered and the first result is a top suggestion.
	QuerySuggestions []*GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion `json:"querySuggestions,omitempty"`
	// TailMatchTriggered: True if the returned suggestions are all tail
	// suggestions. For tail matching to be triggered, include_tail_suggestions in
	// the request must be true and there must be no suggestions that match the
	// full query.
	TailMatchTriggered bool `json:"tailMatchTriggered,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "QuerySuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuerySuggestions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompleteQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion:
// Suggestions as search queries.
type GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion struct {
	// CompletableFieldPaths: The unique document field paths that serve as the
	// source of this suggestion if it was generated from completable fields. This
	// field is only populated for the document-completable model.
	CompletableFieldPaths []string `json:"completableFieldPaths,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletableFieldPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletableFieldPaths") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompletionInfo: Detailed completion information
// including completion attribution token and clicked completion info.
type GoogleCloudDiscoveryengineV1CompletionInfo struct {
	// SelectedPosition: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion position, starting from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`
	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectedPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectedPosition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompletionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompletionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompletionSuggestion: Autocomplete suggestions
// that are imported from Customer.
type GoogleCloudDiscoveryengineV1CompletionSuggestion struct {
	// AlternativePhrases: Alternative matching phrases for this suggestion.
	AlternativePhrases []string `json:"alternativePhrases,omitempty"`
	// Frequency: Frequency of this suggestion. Will be used to rank suggestions
	// when score is not available.
	Frequency int64 `json:"frequency,omitempty,string"`
	// GlobalScore: Global score of this suggestion. Control how this suggestion
	// would be scored / ranked.
	GlobalScore float64 `json:"globalScore,omitempty"`
	// GroupId: If two suggestions have the same groupId, they will not be returned
	// together. Instead the one ranked higher will be returned. This can be used
	// to deduplicate semantically identical suggestions.
	GroupId string `json:"groupId,omitempty"`
	// GroupScore: The score of this suggestion within its group.
	GroupScore float64 `json:"groupScore,omitempty"`
	// LanguageCode: BCP-47 language code of this suggestion.
	LanguageCode string `json:"languageCode,omitempty"`
	// Suggestion: Required. The suggestion text.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativePhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativePhrases") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompletionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompletionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CompletionSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CompletionSuggestion
	var s1 struct {
		GlobalScore gensupport.JSONFloat64 `json:"globalScore"`
		GroupScore  gensupport.JSONFloat64 `json:"groupScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GlobalScore = float64(s1.GlobalScore)
	s.GroupScore = float64(s1.GroupScore)
	return nil
}

// GoogleCloudDiscoveryengineV1Condition: Defines circumstances to be checked
// before allowing a behavior
type GoogleCloudDiscoveryengineV1Condition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1ConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Maximum of 10
	// query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1ConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConditionQueryTerm: Matcher for search request
// query
type GoogleCloudDiscoveryengineV1ConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1ConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Control: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1Control struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig ids this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1ControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1Condition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1ControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1ControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1ControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Control) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Control
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlBoostAction: Adjusts order of products in
// returned list.
type GoogleCloudDiscoveryengineV1ControlBoostAction struct {
	// Boost: Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1ControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1ControlFilterAction: Specified which products
// may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1ControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlRedirectAction: Redirects a shopper to
// the provided URI.
type GoogleCloudDiscoveryengineV1ControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlSynonymsAction: Creates a set of terms
// that will act as synonyms of one another. Example: "happy" will also be
// considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1ControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Conversation: External conversation proto
// definition.
type GoogleCloudDiscoveryengineV1Conversation struct {
	// EndTime: Output only. The time the conversation finished.
	EndTime string `json:"endTime,omitempty"`
	// Messages: Conversation messages.
	Messages []*GoogleCloudDiscoveryengineV1ConversationMessage `json:"messages,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/dataStore/*/con
	// versations/*` or
	// `projects/{project}/locations/global/collections/{collection}/engines/*/conve
	// rsations/*`.
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the Conversation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Conversation is currently open.
	//   "COMPLETED" - Conversation has been completed.
	State string `json:"state,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConversationContext: Defines context of the
// conversation
type GoogleCloudDiscoveryengineV1ConversationContext struct {
	// ActiveDocument: The current active document the user opened. It contains the
	// document resource reference.
	ActiveDocument string `json:"activeDocument,omitempty"`
	// ContextDocuments: The current list of documents the user is seeing. It
	// contains the document resource references.
	ContextDocuments []string `json:"contextDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConversationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConversationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConversationMessage: Defines a conversation
// message.
type GoogleCloudDiscoveryengineV1ConversationMessage struct {
	// CreateTime: Output only. Message creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Reply: Search reply.
	Reply *GoogleCloudDiscoveryengineV1Reply `json:"reply,omitempty"`
	// UserInput: User text input.
	UserInput *GoogleCloudDiscoveryengineV1TextInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConversationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConversationMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConverseConversationRequest: Request message for
// ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1ConverseConversationRequest struct {
	// BoostSpec: Boost specification to boost certain documents in search results
	// which may affect the converse response. For more information on boosting,
	// see Boosting (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Conversation: The conversation to be used by auto session only. The name
	// field will be ignored as we automatically assign new name for the
	// conversation in auto session.
	Conversation *GoogleCloudDiscoveryengineV1Conversation `json:"conversation,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. This will be used to filter
	// search results which may affect the summary response. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// Query: Required. Current user input.
	Query *GoogleCloudDiscoveryengineV1TextInput `json:"query,omitempty"`
	// SafeSearch: Whether to turn on safe search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// ServingConfig: The resource name of the Serving Config to use. Format:
	// `projects/{project_number}/locations/{location_id}/collections/{collection}/d
	// ataStores/{data_store_id}/servingConfigs/{serving_config_id}` If this is not
	// set, the default serving config will be used.
	ServingConfig string `json:"servingConfig,omitempty"`
	// SummarySpec: A specification for configuring the summary returned in the
	// response.
	SummarySpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConverseConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConverseConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConverseConversationResponse: Response message
// for ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1ConverseConversationResponse struct {
	// Conversation: Updated conversation including the answer.
	Conversation *GoogleCloudDiscoveryengineV1Conversation `json:"conversation,omitempty"`
	// Reply: Answer to the current query.
	Reply *GoogleCloudDiscoveryengineV1Reply `json:"reply,omitempty"`
	// SearchResults: Search Results.
	SearchResults []*GoogleCloudDiscoveryengineV1SearchResponseSearchResult `json:"searchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConverseConversationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConverseConversationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateDataStoreMetadata: Metadata related to the
// progress of the DataStoreService.CreateDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateEngineMetadata: Metadata related to the
// progress of the EngineService.CreateEngine operation. This will be returned
// by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateSchemaMetadata: Metadata for Create Schema
// LRO.
type GoogleCloudDiscoveryengineV1CreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.CreateTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateTargetSiteRequest: Request message for
// SiteSearchEngineService.CreateTargetSite method.
type GoogleCloudDiscoveryengineV1CreateTargetSiteRequest struct {
	// Parent: Required. Parent resource name of TargetSite, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine`.
	Parent string `json:"parent,omitempty"`
	// TargetSite: Required. The TargetSite to create.
	TargetSite *GoogleCloudDiscoveryengineV1TargetSite `json:"targetSite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateTargetSiteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateTargetSiteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CustomAttribute: A custom attribute that is not
// explicitly modeled in a resource, e.g. UserEvent.
type GoogleCloudDiscoveryengineV1CustomAttribute struct {
	// Numbers: The numerical values of this custom attribute. For example, `[2.3,
	// 15.4]` when the key is "lengths_cm". Exactly one of CustomAttribute.text or
	// CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	Numbers []float64 `json:"numbers,omitempty"`
	// Text: The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color". Empty string is not allowed. Otherwise,
	// an `INVALID_ARGUMENT` error is returned. Exactly one of CustomAttribute.text
	// or CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Numbers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Numbers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CustomAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CustomAttribute) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CustomAttribute
	var s1 struct {
		Numbers []gensupport.JSONFloat64 `json:"numbers"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Numbers = make([]float64, len(s1.Numbers))
	for i := range s1.Numbers {
		s.Numbers[i] = float64(s1.Numbers[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1DataStore: DataStore captures global settings
// and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1DataStore struct {
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema asscociated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1Schema `json:"startingSchema,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata: Metadata related to the
// progress of the DataStoreService.DeleteDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteEngineMetadata: Metadata related to the
// progress of the EngineService.DeleteEngine operation. This will be returned
// by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteSchemaMetadata: Metadata for DeleteSchema
// LRO.
type GoogleCloudDiscoveryengineV1DeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.DeleteTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest: Request
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1Document: Document captures all raw metadata
// information of items to be recommended or searched.
type GoogleCloudDiscoveryengineV1Document struct {
	// Content: The unstructured data linked to this document. Content must be set
	// if this document is under a `CONTENT_REQUIRED` data store.
	Content *GoogleCloudDiscoveryengineV1DocumentContent `json:"content,omitempty"`
	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It contains
	// derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`
	// Id: Immutable. The identifier of the document. Id should conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
	// characters.
	Id string `json:"id,omitempty"`
	// IndexTime: Output only. The last time the document was indexed. If this
	// field is set, the document could be returned in search results. This field
	// is OUTPUT_ONLY. If this field is not populated, it means the document has
	// never been indexed.
	IndexTime string `json:"indexTime,omitempty"`
	// JsonData: The JSON string representation of the document. It should conform
	// to the registered Schema or an `INVALID_ARGUMENT` error is thrown.
	JsonData string `json:"jsonData,omitempty"`
	// Name: Immutable. The full resource name of the document. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document_id}`. This field must be
	// a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ParentDocumentId: The identifier of the parent document. Currently supports
	// at most two level document hierarchy. Id should conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
	// characters.
	ParentDocumentId string `json:"parentDocumentId,omitempty"`
	// SchemaId: The identifier of the schema located in the same data store.
	SchemaId string `json:"schemaId,omitempty"`
	// StructData: The structured JSON data for the document. It should conform to
	// the registered Schema or an `INVALID_ARGUMENT` error is thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentContent: Unstructured data linked to
// this document.
type GoogleCloudDiscoveryengineV1DocumentContent struct {
	// MimeType: The MIME type of the content. Supported types: * `application/pdf`
	// (PDF, only native PDFs are supported for now) * `text/html` (HTML) *
	// `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
	// (DOCX) *
	// `application/vnd.openxmlformats-officedocument.presentationml.presentation`
	// (PPTX) * `text/plain` (TXT) See
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`
	// RawBytes: The content represented as a stream of bytes. The maximum length
	// is 1,000,000 bytes (1 MB / ~0.95 MiB). Note: As with all `bytes` fields,
	// this field is represented as pure binary in Protocol Buffers and
	// base64-encoded string in JSON. For example, `abc123!?$*&()'-=@~` should be
	// represented as `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	RawBytes string `json:"rawBytes,omitempty"`
	// Uri: The URI of the content. Only Cloud Storage URIs (e.g.
	// `gs://bucket-name/path/to/file`) are supported. The maximum file size is 2.5
	// MB for text-based formats, 200 MB for other formats.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentInfo: Detailed document information
// associated with a user event.
type GoogleCloudDiscoveryengineV1DocumentInfo struct {
	// Id: The Document resource ID.
	Id string `json:"id,omitempty"`
	// Name: The Document resource full name, of the form:
	// `projects/{project_id}/locations/{location}/collections/{collection_id}/dataS
	// tores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
	Name string `json:"name,omitempty"`
	// PromotionIds: The promotion IDs associated with this Document. Currently,
	// this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`
	// Quantity: Quantity of the Document associated with the user event. Defaults
	// to 1. For example, this field is 2 if two quantities of the same Document
	// are involved in a `add-to-cart` event. Required for events of the following
	// event types: * `add-to-cart` * `purchase`
	Quantity int64 `json:"quantity,omitempty"`
	// Uri: The Document URI - only allowed for website data stores.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfig: A singleton resource
// of DataStore. It's empty when DataStore is created, which defaults to
// digital parser. The first call to
// DataStoreService.UpdateDocumentProcessingConfig method will initialize the
// config.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBased
// ChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig: Related
// configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsi
// ngConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsin
// gConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingCo
// nfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest: Request message
// for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1Engine: Metadata that describes the training and
// serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1Engine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1EngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1EngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1EngineCommonConfig `json:"commonConfig,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// IndustryVertical: The industry vertical that the engine registers. The
	// restriction of the Engine industry vertical is based on DataStore: If
	// unspecified, default to `GENERIC`. Vertical on Engine has to match vertical
	// of the DataStore linked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// Name: Immutable. The fully qualified resource name of the engine. This field
	// must be a UTF-8 encoded string with a length limit of 1024 characters.
	// Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/engi
	// nes/{engine}` engine should be 1-63 characters, and valid characters are
	// /a-z0-9*/. Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1EngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatEngineConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Engine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Engine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineConfig: Configurations for a
// Chat Engine.
type GoogleCloudDiscoveryengineV1EngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineMetadata: Additional information
// of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1EngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineCommonConfig: Common configurations for an
// Engine.
type GoogleCloudDiscoveryengineV1EngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineSearchEngineConfig: Configurations for a
// Search Engine.
type GoogleCloudDiscoveryengineV1EngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FactChunk: Fact Chunk.
type GoogleCloudDiscoveryengineV1FactChunk struct {
	// ChunkText: Text content of the fact chunk. Can be at most 10K characters
	// long.
	ChunkText string `json:"chunkText,omitempty"`
	// Index: The index of this chunk. Currently, only used for the streaming mode.
	Index int64 `json:"index,omitempty"`
	// Source: Source from which this fact chunk was retrieved. If it was retrieved
	// from the GroundingFacts provided in the request then this field will contain
	// the index of the specific fact from which this chunk was retrieved.
	Source string `json:"source,omitempty"`
	// SourceMetadata: More fine-grained information for the source reference.
	SourceMetadata map[string]string `json:"sourceMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FactChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FactChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse: Response
// message for SiteSearchEngineService.FetchDomainVerificationStatus method.
type GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TargetSites: List of TargetSites containing the site verification status.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// TotalSize: The total number of items matching the request. This will always
	// be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FhirStoreSource: Cloud FhirStore source import
// data from.
type GoogleCloudDiscoveryengineV1FhirStoreSource struct {
	// FhirStore: Required. The full resource name of the FHIR store to import data
	// from, in the format of
	// `projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_
	// store}`.
	FhirStore string `json:"fhirStore,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the FhirStore export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FhirStoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FhirStoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FirestoreSource: Firestore source import data
// from.
type GoogleCloudDiscoveryengineV1FirestoreSource struct {
	// CollectionId: Required. The Firestore collection (or entity) to copy the
	// data from with a length limit of 1,500 characters.
	CollectionId string `json:"collectionId,omitempty"`
	// DatabaseId: Required. The Firestore database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the Firestore export to a specific Cloud Storage directory. Ensure that the
	// Firestore service account has the necessary Cloud Storage Admin permissions
	// to access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// ProjectId: The project ID that the Cloud SQL source is in with a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FirestoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FirestoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1GcsSource: Cloud Storage location for input
// content.
type GoogleCloudDiscoveryengineV1GcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for document imports: * `document` (default): One JSON
	// Document per line. Each document must have a valid Document.id. * `content`:
	// Unstructured data (e.g. PDF, HTML). Each file matched by `input_uris`
	// becomes a document, with the ID set to the first 128 bits of SHA256(URI)
	// encoded as a hex string. * `custom`: One custom data JSON per row in
	// arbitrary format that conforms to the defined Schema of the data store. This
	// can only be used by the GENERIC Data Store vertical. * `csv`: A CSV file
	// with header conforming to the defined Schema of the data store. Each entry
	// after the header is imported as a Document. This can only be used by the
	// GENERIC Data Store vertical. Supported values for user event imports: *
	// `user_event` (default): One JSON UserEvent per line.
	DataSchema string `json:"dataSchema,omitempty"`
	// InputUris: Required. Cloud Storage URIs to input files. Each URI can be up
	// to 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`. A request can contain at most
	// 100 files (or 100,000 files if `data_schema` is `content`). Each file can be
	// up to 2 GB (or 100 MB if `data_schema` is `content`).
	InputUris []string `json:"inputUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1GroundingFact: Grounding Fact.
type GoogleCloudDiscoveryengineV1GroundingFact struct {
	// Attributes: Attributes associated with the fact. Common attributes include
	// `source` (indicating where the fact was sourced from), `author` (indicating
	// the author of the fact), and so on.
	Attributes map[string]string `json:"attributes,omitempty"`
	// FactText: Text content of the fact. Can be at most 10K characters long.
	FactText string `json:"factText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1GroundingFact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1GroundingFact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata: Metadata
// related to the progress of the ImportCompletionSuggestions operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest: Request
// message for CompletionService.ImportCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1BigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for suggestion entries.
	InlineSource *GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource:
// The inline source for CompletionSuggestions.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource struct {
	// Suggestions: Required. A list of all denylist entries to import. Max of 1000
	// items.
	Suggestions []*GoogleCloudDiscoveryengineV1CompletionSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse: Response of
// the CompletionService.ImportCompletionSuggestions method. If the long
// running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsMetadata: Metadata related to the
// progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsRequest: Request message for
// Import methods.
type GoogleCloudDiscoveryengineV1ImportDocumentsRequest struct {
	// AlloyDbSource: AlloyDB input source.
	AlloyDbSource *GoogleCloudDiscoveryengineV1AlloyDbSource `json:"alloyDbSource,omitempty"`
	// AutoGenerateIds: Whether to automatically generate IDs for the documents if
	// absent. If set to `true`, Document.ids are automatically generated based on
	// the hash of the payload, where IDs may not be consistent during multiple
	// imports. In which case ReconciliationMode.FULL is highly recommended to
	// avoid duplicate contents. If unset or set to `false`, Document.ids have to
	// be specified using id_field, otherwise, documents without IDs fail to be
	// imported. Supported data sources: * GcsSource. GcsSource.data_schema must be
	// `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. *
	// BigQuerySource. BigQuerySource.data_schema must be `custom` or `csv`.
	// Otherwise, an INVALID_ARGUMENT error is thrown. * SpannerSource. *
	// CloudSqlSource. * FirestoreSource. * BigtableSource.
	AutoGenerateIds bool `json:"autoGenerateIds,omitempty"`
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1BigQuerySource `json:"bigquerySource,omitempty"`
	// BigtableSource: Cloud Bigtable input source.
	BigtableSource *GoogleCloudDiscoveryengineV1BigtableSource `json:"bigtableSource,omitempty"`
	// CloudSqlSource: Cloud SQL input source.
	CloudSqlSource *GoogleCloudDiscoveryengineV1CloudSqlSource `json:"cloudSqlSource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// FhirStoreSource: FhirStore input source.
	FhirStoreSource *GoogleCloudDiscoveryengineV1FhirStoreSource `json:"fhirStoreSource,omitempty"`
	// FirestoreSource: Firestore input source.
	FirestoreSource *GoogleCloudDiscoveryengineV1FirestoreSource `json:"firestoreSource,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// IdField: The field indicates the ID field or column to be used as unique IDs
	// of the documents. For GcsSource it is the key of the JSON field. For
	// instance, `my_id` for JSON `{"my_id": "some_uuid"}`. For others, it may be
	// the column name of the table where the unique ids are stored. The values of
	// the JSON field or the table column are used as the Document.ids. The JSON
	// field or the table column must be of string type, and the values must be set
	// as valid strings conform to RFC-1034 (https://tools.ietf.org/html/rfc1034)
	// with 1-63 characters. Otherwise, documents without valid IDs fail to be
	// imported. Only set this field when auto_generate_ids is unset or set as
	// `false`. Otherwise, an INVALID_ARGUMENT error is thrown. If it is unset, a
	// default value `_id` is used when importing from the allowed data sources.
	// Supported data sources: * GcsSource. GcsSource.data_schema must be `custom`
	// or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * BigQuerySource.
	// BigQuerySource.data_schema must be `custom` or `csv`. Otherwise, an
	// INVALID_ARGUMENT error is thrown. * SpannerSource. * CloudSqlSource. *
	// FirestoreSource. * BigtableSource.
	IdField string `json:"idField,omitempty"`
	// InlineSource: The Inline source for the input content for documents.
	InlineSource *GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource `json:"inlineSource,omitempty"`
	// ReconciliationMode: The mode of reconciliation between existing documents
	// and the documents to be imported. Defaults to
	// ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to `INCREMENTAL`.
	//   "INCREMENTAL" - Inserts new documents or updates existing documents.
	//   "FULL" - Calculates diff and replaces the entire document dataset.
	// Existing documents may be deleted if they are not present in the source
	// location.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`
	// SpannerSource: Spanner input source.
	SpannerSource *GoogleCloudDiscoveryengineV1SpannerSource `json:"spannerSource,omitempty"`
	// UpdateMask: Indicates which fields in the provided imported documents to
	// update. If not set, the default is to update all fields.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlloyDbSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlloyDbSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource: The inline
// source for the input config for ImportDocuments method.
type GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource struct {
	// Documents: Required. A list of documents to update/create. Each document
	// must have a valid Document.id. Recommended max of 100 items.
	Documents []*GoogleCloudDiscoveryengineV1Document `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1ImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportErrorConfig: Configuration of destination
// for Import related errors.
type GoogleCloudDiscoveryengineV1ImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest: Request
// message for CompletionService.ImportSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest struct {
	// GcsSource: Cloud Storage location for the input content. Only 1 file can be
	// specified that contains all entries to import. Supported values
	// `gcs_source.schema` for autocomplete suggestion deny list entry imports: *
	// `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry] per
	// line.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for the input content for suggestion deny
	// list entries.
	InlineSource *GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSourc
// e: The inline source for SuggestionDenyListEntry.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource struct {
	// Entries: Required. A list of all denylist entries to import. Max of 1000
	// items.
	Entries []*GoogleCloudDiscoveryengineV1SuggestionDenyListEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsMetadata: Metadata related to
// the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsRequest: Request message for the
// ImportUserEvents request.
type GoogleCloudDiscoveryengineV1ImportUserEventsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1BigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	// Cannot be set for inline user event imports.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for the input content for UserEvents.
	InlineSource *GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource: The inline
// source for the input config for ImportUserEvents method.
type GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended max of
	// 10k items.
	UserEvents []*GoogleCloudDiscoveryengineV1UserEvent `json:"userEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1ImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Interval: A floating point interval.
type GoogleCloudDiscoveryengineV1Interval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`
	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`
	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`
	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Interval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Interval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1Interval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1Interval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudDiscoveryengineV1ListControlsResponse: Response for ListControls
// method.
type GoogleCloudDiscoveryengineV1ListControlsResponse struct {
	// Controls: All the Controls for a given data store.
	Controls []*GoogleCloudDiscoveryengineV1Control `json:"controls,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Controls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Controls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListControlsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListControlsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListConversationsResponse: Response for
// ListConversations method.
type GoogleCloudDiscoveryengineV1ListConversationsResponse struct {
	// Conversations: All the Conversations for a given data store.
	Conversations []*GoogleCloudDiscoveryengineV1Conversation `json:"conversations,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListDataStoresResponse: Response message for
// DataStoreService.ListDataStores method.
type GoogleCloudDiscoveryengineV1ListDataStoresResponse struct {
	// DataStores: All the customer's DataStores.
	DataStores []*GoogleCloudDiscoveryengineV1DataStore `json:"dataStores,omitempty"`
	// NextPageToken: A token that can be sent as ListDataStoresRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListDataStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListDataStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListDocumentsResponse: Response message for
// DocumentService.ListDocuments method.
type GoogleCloudDiscoveryengineV1ListDocumentsResponse struct {
	// Documents: The Documents.
	Documents []*GoogleCloudDiscoveryengineV1Document `json:"documents,omitempty"`
	// NextPageToken: A token that can be sent as ListDocumentsRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListEnginesResponse: Response message for
// EngineService.ListEngines method.
type GoogleCloudDiscoveryengineV1ListEnginesResponse struct {
	// Engines: All the customer's Engines.
	Engines []*GoogleCloudDiscoveryengineV1Engine `json:"engines,omitempty"`
	// NextPageToken: Not supported.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Engines") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListEnginesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListEnginesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListSchemasResponse: Response message for
// SchemaService.ListSchemas method.
type GoogleCloudDiscoveryengineV1ListSchemasResponse struct {
	// NextPageToken: A token that can be sent as ListSchemasRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Schemas: The Schemas.
	Schemas []*GoogleCloudDiscoveryengineV1Schema `json:"schemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListSchemasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListSessionsResponse: Response for ListSessions
// method.
type GoogleCloudDiscoveryengineV1ListSessionsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sessions: All the Sessions for a given data store.
	Sessions []*GoogleCloudDiscoveryengineV1Session `json:"sessions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListSessionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListTargetSitesResponse: Response message for
// SiteSearchEngineService.ListTargetSites method.
type GoogleCloudDiscoveryengineV1ListTargetSitesResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TargetSites: List of TargetSites.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// TotalSize: The total number of items matching the request. This will always
	// be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1MediaInfo: Media-specific user event
// information.
type GoogleCloudDiscoveryengineV1MediaInfo struct {
	// MediaProgressDuration: The media progress time in seconds, if applicable.
	// For example, if the end user has finished 90 seconds of a playback video,
	// then MediaInfo.media_progress_duration.seconds should be set to 90.
	MediaProgressDuration string `json:"mediaProgressDuration,omitempty"`
	// MediaProgressPercentage: Media progress should be computed using only the
	// media_progress_duration relative to the media total length. This value must
	// be between `[0, 1.0]` inclusive. If this is not a playback or the progress
	// cannot be computed (e.g. ongoing livestream), this field should be unset.
	MediaProgressPercentage float64 `json:"mediaProgressPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaProgressDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaProgressDuration") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1MediaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1MediaInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1MediaInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1MediaInfo
	var s1 struct {
		MediaProgressPercentage gensupport.JSONFloat64 `json:"mediaProgressPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MediaProgressPercentage = float64(s1.MediaProgressPercentage)
	return nil
}

// GoogleCloudDiscoveryengineV1PageInfo: Detailed page information.
type GoogleCloudDiscoveryengineV1PageInfo struct {
	// PageCategory: The most specific category associated with a category page. To
	// represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, replace it with other
	// character(s). Category pages include special pages such as sales or
	// promotions. For instance, a special sale page may have the category
	// hierarchy: "pageCategory" : "Sales > 2017 Black Friday Deals". Required
	// for `view-category-page` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageCategory string `json:"pageCategory,omitempty"`
	// PageviewId: A unique ID of a web page view. This should be kept the same for
	// all user events triggered from the same pageview. For example, an item
	// detail page view could trigger multiple events as the user is browsing the
	// page. The `pageview_id` property should be kept the same for all these
	// events so that they can be grouped together properly. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically.
	PageviewId string `json:"pageviewId,omitempty"`
	// ReferrerUri: The referrer URL of the current page. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically. However, some browser privacy restrictions
	// may cause this field to be empty.
	ReferrerUri string `json:"referrerUri,omitempty"`
	// Uri: Complete URL (window.location.href) of the user's current page. When
	// using the client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically. Maximum length 5,000
	// characters.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageCategory") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PanelInfo: Detailed panel information associated
// with a user event.
type GoogleCloudDiscoveryengineV1PanelInfo struct {
	// DisplayName: The display name of the panel.
	DisplayName string `json:"displayName,omitempty"`
	// PanelId: Required. The panel ID.
	PanelId string `json:"panelId,omitempty"`
	// PanelPosition: The ordered position of the panel, if shown to the user with
	// other panels. If set, then total_panels must also be set.
	PanelPosition int64 `json:"panelPosition,omitempty"`
	// TotalPanels: The total number of panels, including this one, shown to the
	// user. Must be set if panel_position is set.
	TotalPanels int64 `json:"totalPanels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PanelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PanelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Project: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1Project struct {
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project_number}`. Note that when making requests, project number
	// and project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1ProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Project) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Project
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectServiceTerms: Metadata about the terms of
// service.
type GoogleCloudDiscoveryengineV1ProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProvisionProjectMetadata: Metadata associated
// with a project provision operation.
type GoogleCloudDiscoveryengineV1ProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1ProvisionProjectRequest: Request for
// ProjectService.ProvisionProject method.
type GoogleCloudDiscoveryengineV1ProvisionProjectRequest struct {
	// AcceptDataUseTerms: Required. Set to `true` to specify that caller has read
	// and would like to give consent to the Terms for data use
	// (https://cloud.google.com/retail/data-use-terms).
	AcceptDataUseTerms bool `json:"acceptDataUseTerms,omitempty"`
	// DataUseTermsVersion: Required. The version of the Terms for data use
	// (https://cloud.google.com/retail/data-use-terms) that caller has read and
	// would like to give consent to. Acceptable version is `2022-11-23`, and this
	// may change over time.
	DataUseTermsVersion string `json:"dataUseTermsVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptDataUseTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptDataUseTerms") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProvisionProjectRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProvisionProjectRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata: Metadata
// related to the progress of the PurgeCompletionSuggestions operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest: Request
// message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest struct {
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse: Response
// message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeSucceeded: Whether the completion suggestions were successfully purged.
	PurgeSucceeded bool `json:"purgeSucceeded,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata: Metadata related to the
// progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsRequest: Request message for
// DocumentService.PurgeDocuments method.
type GoogleCloudDiscoveryengineV1PurgeDocumentsRequest struct {
	// Filter: Required. Filter matching documents to purge. Only currently
	// supported value is `*` (all items).
	Filter string `json:"filter,omitempty"`
	// Force: Actually performs the purge. If `force` is set to false, return the
	// expected purge count without deleting any documents.
	Force bool `json:"force,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsResponse: Response message for
// DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata: Metadata
// related to the progress of the PurgeSuggestionDenyListEntries operation.
// This is returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesRequest: Request
// message for CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesRequest struct {
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse: Response
// message for CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Query: Defines a user inputed query.
type GoogleCloudDiscoveryengineV1Query struct {
	// QueryId: Unique Id for the query.
	QueryId string `json:"queryId,omitempty"`
	// Text: Plain text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Query) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Query
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RankRequest: Request message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1RankRequest struct {
	// IgnoreRecordDetailsInResponse: If true, the response will contain only
	// record ID and score. By default, it is false, the response will contain
	// record details.
	IgnoreRecordDetailsInResponse bool `json:"ignoreRecordDetailsInResponse,omitempty"`
	// Model: The identifier of the model to use. It is one of: *
	// `semantic-ranker-512@latest`: Semantic ranking model with maxiumn input
	// token size 512. It is set to `semantic-ranker-512@latest` by default if
	// unspecified.
	Model string `json:"model,omitempty"`
	// Query: The query to use.
	Query string `json:"query,omitempty"`
	// Records: Required. A list of records to rank. At most 200 records to rank.
	Records []*GoogleCloudDiscoveryengineV1RankingRecord `json:"records,omitempty"`
	// TopN: The number of results to return. If this is unset or no bigger than
	// zero, returns all results.
	TopN int64 `json:"topN,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "IgnoreRecordDetailsInResponse") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreRecordDetailsInResponse")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RankRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RankRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RankResponse: Response message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1RankResponse struct {
	// Records: A list of records sorted by descending score.
	Records []*GoogleCloudDiscoveryengineV1RankingRecord `json:"records,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Records") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Records") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RankResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RankResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RankingRecord: Record message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1RankingRecord struct {
	// Content: The content of the record. Empty by default. At least one of title
	// or content should be set otherwise an INVALID_ARGUMENT error is thrown.
	Content string `json:"content,omitempty"`
	// Id: The unique ID to represent the record.
	Id string `json:"id,omitempty"`
	// Score: The score of this record based on the given query and selected model.
	Score float64 `json:"score,omitempty"`
	// Title: The title of the record. Empty by default. At least one of title or
	// content should be set otherwise an INVALID_ARGUMENT error is thrown.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RankingRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RankingRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1RankingRecord) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1RankingRecord
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1RecommendRequest: Request message for Recommend
// method.
type GoogleCloudDiscoveryengineV1RecommendRequest struct {
	// Filter: Filter for restricting recommendation results with a length limit of
	// 5,000 characters. Currently, only filter expressions on the `filter_tags`
	// attribute is supported. Examples: * `(filter_tags: ANY("Red", "Blue") OR
	// filter_tags: ANY("Hot", "Cold"))` * `(filter_tags: ANY("Red", "Blue")) AND
	// NOT (filter_tags: ANY("Green"))` If `attributeFilteringSyntax` is set to
	// true under the `params` field, then attribute-based expressions are expected
	// instead of the above described tag-based syntax. Examples: * (launguage:
	// ANY("en", "es")) AND NOT (categories: ANY("Movie")) * (available: true) AND
	// (launguage: ANY("en", "es")) OR (categories: ANY("Movie")) If your filter
	// blocks all results, the API returns generic (unfiltered) popular Documents.
	// If you only want results strictly matching the filters, set
	// `strictFiltering` to `true` in RecommendRequest.params to receive empty
	// results instead. Note that the API never returns Documents with
	// `storageStatus` as `EXPIRED` or `DELETED` regardless of filter choices.
	Filter string `json:"filter,omitempty"`
	// PageSize: Maximum number of results to return. Set this property to the
	// number of recommendation results needed. If zero, the service chooses a
	// reasonable default. The maximum allowed value is 100. Values above 100 are
	// set to 100.
	PageSize int64 `json:"pageSize,omitempty"`
	// Params: Additional domain specific parameters for the recommendations.
	// Allowed values: * `returnDocument`: Boolean. If set to `true`, the
	// associated Document object is returned in
	// RecommendResponse.RecommendationResult.document. * `returnScore`: Boolean.
	// If set to true, the recommendation score corresponding to each returned
	// Document is set in RecommendResponse.RecommendationResult.metadata. The
	// given score indicates the probability of a Document conversion given the
	// user's context and history. * `strictFiltering`: Boolean. True by default.
	// If set to `false`, the service returns generic (unfiltered) popular
	// Documents instead of empty if your filter blocks all recommendation results.
	// * `diversityLevel`: String. Default empty. If set to be non-empty, then it
	// needs to be one of: * `no-diversity` * `low-diversity` * `medium-diversity`
	// * `high-diversity` * `auto-diversity` This gives request-level control and
	// adjusts recommendation results based on Document category. *
	// `attributeFilteringSyntax`: Boolean. False by default. If set to true, the
	// `filter` field is interpreted according to the new, attribute-based syntax.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// UserEvent: Required. Context about the user, what they are looking at and
	// what action they took to trigger the Recommend request. Note that this user
	// event detail won't be ingested to userEvent logs. Thus, a separate userEvent
	// write request is required for event logging. Don't set
	// UserEvent.user_pseudo_id or UserEvent.user_info.user_id to the same fixed ID
	// for different users. If you are trying to receive non-personalized
	// recommendations (not recommended; this can negatively impact model
	// performance), instead set UserEvent.user_pseudo_id to a random unique ID and
	// leave UserEvent.user_info.user_id unset.
	UserEvent *GoogleCloudDiscoveryengineV1UserEvent `json:"userEvent,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Requirements for labels
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ValidateOnly: Use validate only mode for this recommendation query. If set
	// to `true`, a fake model is used that returns arbitrary Document IDs. Note
	// that the validate only mode should only be used for testing the API, or if
	// the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecommendRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecommendRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RecommendResponse: Response message for
// Recommend method.
type GoogleCloudDiscoveryengineV1RecommendResponse struct {
	// AttributionToken: A unique attribution token. This should be included in the
	// UserEvent logs resulting from this recommendation, which enables accurate
	// attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// MissingIds: IDs of documents in the request that were missing from the
	// default Branch associated with the requested ServingConfig.
	MissingIds []string `json:"missingIds,omitempty"`
	// Results: A list of recommended Documents. The order represents the ranking
	// (from the most relevant Document to the least).
	Results []*GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult `json:"results,omitempty"`
	// ValidateOnly: True if RecommendRequest.validate_only was set.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecommendResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecommendResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult:
// RecommendationResult represents a generic recommendation result with
// associated metadata.
type GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult struct {
	// Document: Set if `returnDocument` is set to true in RecommendRequest.params.
	Document *GoogleCloudDiscoveryengineV1Document `json:"document,omitempty"`
	// Id: Resource ID of the recommended Document.
	Id string `json:"id,omitempty"`
	// Metadata: Additional Document metadata or annotations. Possible values: *
	// `score`: Recommendation score in double value. Is set if `returnScore` is
	// set to true in RecommendRequest.params.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RecrawlUrisRequest: Request message for
// SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1RecrawlUrisRequest struct {
	// Uris: Required. List of URIs to crawl. At most 10K URIs are supported,
	// otherwise an INVALID_ARGUMENT error is thrown. Each URI should match at
	// least one TargetSite in `site_search_engine`.
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uris") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecrawlUrisRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecrawlUrisRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Reply: Defines a reply message to user.
type GoogleCloudDiscoveryengineV1Reply struct {
	// Summary: Summary based on search results.
	Summary *GoogleCloudDiscoveryengineV1SearchResponseSummary `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Summary") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Summary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Reply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Reply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Schema: Defines the structure and layout of a
// type of document data.
type GoogleCloudDiscoveryengineV1Schema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JsonSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchInfo: Detailed search information.
type GoogleCloudDiscoveryengineV1SearchInfo struct {
	// Offset: An integer that specifies the current offset for pagination (the
	// 0-indexed starting location, amongst the products deemed by the API as
	// relevant). See SearchRequest.offset for definition. If this field is
	// negative, an `INVALID_ARGUMENT` is returned. This can only be set for
	// `search` events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order in which products are returned, if applicable. See
	// SearchRequest.order_by for definition and syntax. The value must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. This can only be set for `search`
	// events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. At
	// least one of search_query or PageInfo.page_category is required for `search`
	// events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Offset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Offset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1SearchRequest struct {
	// BoostSpec: Boost specification to boost certain documents. For more
	// information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Branch: The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/defaul
	// t_data_store/branches/0`. Use `default_branch` as the branch ID or leave
	// this field empty, to search documents under the default branch.
	Branch string `json:"branch,omitempty"`
	// CanonicalFilter: The default filter that is applied when a user performs a
	// search without checking any filters on the search page. The filter applied
	// to every search request when quality improvement such as query expansion is
	// needed. In the case a query does not have a sufficient amount of results
	// this filter will be used to determine whether or not to enable the query
	// expansion flow. The original filter will still be used for the query
	// expanded search. This field is strongly recommended to achieve high search
	// quality. For more information about filter syntax, see SearchRequest.filter.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`
	// ContentSearchSpec: A specification for configuring the behavior of content
	// search.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`
	// DataStoreSpecs: Specs defining dataStores to filter on in a search call and
	// configurations for those dataStores. This is only considered for engines
	// with multiple dataStores use case. For single dataStore within an engine,
	// they should use the specs at the top level.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// FacetSpecs: Facet specifications for faceted search. If empty, no facets are
	// returned. A maximum of 100 values are allowed. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	FacetSpecs []*GoogleCloudDiscoveryengineV1SearchRequestFacetSpec `json:"facetSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ImageQuery: Raw image query.
	ImageQuery *GoogleCloudDiscoveryengineV1SearchRequestImageQuery `json:"imageQuery,omitempty"`
	// LanguageCode: The BCP-47 language code, such as "en-US" or "sr-Latn". For
	// more information, see Standard fields
	// (https://cloud.google.com/apis/design/standard_fields). This field helps to
	// better interpret the query. If a value isn't specified, the query language
	// code is automatically detected, which may not be accurate.
	LanguageCode string `json:"languageCode,omitempty"`
	// Offset: A 0-indexed integer that specifies the current offset (that is,
	// starting result location, amongst the Documents deemed by the API as
	// relevant) in search results. This field is only considered if page_token is
	// unset. If this field is negative, an `INVALID_ARGUMENT` is returned.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering
	// for retail search, see Ordering
	// (https://cloud.google.com/retail/docs/filter-and-order#order) If this field
	// is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: Maximum number of Documents to return. The maximum allowed value
	// depends on the data type. Values above the maximum value are coerced to the
	// maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. *
	// Websites with advanced indexing: Default `25`, Maximum `50`. * Other:
	// Default `50`, Maximum `100`. If this field is negative, an
	// `INVALID_ARGUMENT` is returned.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token received from a previous SearchService.Search call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to SearchService.Search must match the call that
	// provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// Params: Additional search parameters. For public website search only,
	// supported values are: * `user_country_code`: string. Default empty. If set
	// to non-empty, results are restricted or boosted based on the location
	// provided. For example, `user_country_code: "au" For available codes see
	// Country Codes
	// (https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
	// * `search_type`: double. Default empty. Enables non-webpage searching
	// depending on the value. The only valid non-default value is 1, which enables
	// image searching. For example, `search_type: 1`
	Params googleapi.RawMessage `json:"params,omitempty"`
	// Query: Raw search query.
	Query string `json:"query,omitempty"`
	// QueryExpansionSpec: The query expansion specification that specifies the
	// conditions under which query expansion occurs.
	QueryExpansionSpec *GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`
	// SafeSearch: Whether to turn on safe search. This is only supported for
	// website search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// SearchAsYouTypeSpec: Search as you type configuration. Only supported for
	// the IndustryVertical.MEDIA vertical.
	SearchAsYouTypeSpec *GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec `json:"searchAsYouTypeSpec,omitempty"`
	// Session: The session resource name. Optional. Session allows users to do
	// multi-turn /search API calls or coordination between /search API calls and
	// /answer API calls. Example #1 (multi-turn /search API calls): 1. Call
	// /search API with the auto-session mode (see below). 2. Call /search API with
	// the session ID generated in the first call. Here, the previous search query
	// gets considered in query standing. I.e., if the first query is "How did
	// Alphabet do in 2022?" and the current query is "How about 2023?", the
	// current query will be interpreted as "How did Alphabet do in 2023?". Example
	// #2 (coordination between /search API calls and /answer API calls): 1. Call
	// /search API with the auto-session mode (see below). 2. Call /answer API with
	// the session ID generated in the first call. Here, the answer generation
	// happens in the context of the search results from the first search call.
	// Auto-session mode: when `projects/.../sessions/-` is used, a new session
	// gets automatically created. Otherwise, users can use the create-session API
	// to create a session manually. Multi-turn Search feature is currently at
	// private GA stage. Please use v1alpha or v1beta version instead before we
	// launch this feature to public GA. Or ask for allowlisting through Google
	// Support team.
	Session string `json:"session,omitempty"`
	// SessionSpec: Session specification. Can be used only when `session` is set.
	SessionSpec *GoogleCloudDiscoveryengineV1SearchRequestSessionSpec `json:"sessionSpec,omitempty"`
	// SpellCorrectionSpec: The spell correction specification that specifies the
	// mode under which spell correction takes effect.
	SpellCorrectionSpec *GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec `json:"spellCorrectionSpec,omitempty"`
	// UserInfo: Information about the end user. Highly recommended for analytics.
	// UserInfo.user_agent is used to deduce `device_type` for analytics.
	UserInfo *GoogleCloudDiscoveryengineV1UserInfo `json:"userInfo,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. This should be the same
	// identifier as UserEvent.user_pseudo_id and
	// CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestBoostSpec: Boost specification to
// boost certain documents.
type GoogleCloudDiscoveryengineV1SearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a document matches
	// multiple conditions in the specifictions, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec: Boost
// applies to documents which match a condition.
type GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the document a
	// big promotion. However, it does not necessarily mean that the boosted
	// document will be the top result at all times, nor that other documents will
	// be excluded. Results could still be shown even when none of them matches the
	// condition. And results that are significantly more relevant to the search
	// query can still trump your heavily favored but irrelevant documents. Setting
	// to -1.0 gives the document a big demotion. However, results that are deeply
	// relevant might still be shown. The document will have an upstream battle to
	// get a fairly high ranking, but it is not blocked out completely. Setting to
	// 0.0 means no boost applied. The boosting condition is ignored. Only one of
	// the (condition, boost) combination or the boost_control_spec below are set.
	// If both are set then the global boost is ignored and the more fine-grained
	// boost_control_spec is applied.
	Boost float64 `json:"boost,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: * To boost
	// documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue":
	// `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec: A specification
// for configuring the behavior of content search.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec struct {
	// ChunkSpec: Specifies the chunk spec to be returned from the search response.
	// Only available if the SearchRequest.ContentSearchSpec.search_result_mode is
	// set to CHUNKS
	ChunkSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec `json:"chunkSpec,omitempty"`
	// ExtractiveContentSpec: If there is no extractive_content_spec provided,
	// there will be no extractive answer in the search response.
	ExtractiveContentSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec `json:"extractiveContentSpec,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode is based on
	// DataStore.DocumentProcessingConfig.chunking_config: * If
	// DataStore.DocumentProcessingConfig.chunking_config is specified, it defaults
	// to `CHUNKS`. * Otherwise, it defaults to `DOCUMENTS`.
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DataStore.DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// SnippetSpec: If `snippetSpec` is not specified, snippets are not included in
	// the search response.
	SnippetSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec `json:"snippetSpec,omitempty"`
	// SummarySpec: If `summarySpec` is not specified, summaries are not included
	// in the search response.
	SummarySpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec:
// Specifies the chunk spec to be returned from the search response. Only
// available if the SearchRequest.ContentSearchSpec.search_result_mode is set
// to CHUNKS
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec struct {
	// NumNextChunks: The number of next chunks to be returned of the current
	// chunk. The maximum allowed value is 3. If not specified, no next chunks will
	// be returned.
	NumNextChunks int64 `json:"numNextChunks,omitempty"`
	// NumPreviousChunks: The number of previous chunks to be returned of the
	// current chunk. The maximum allowed value is 3. If not specified, no previous
	// chunks will be returned.
	NumPreviousChunks int64 `json:"numPreviousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumNextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumNextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSp
// ec: A specification for configuring the extractive content in a search
// response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec struct {
	// MaxExtractiveAnswerCount: The maximum number of extractive answers returned
	// in each search result. An extractive answer is a verbatim answer extracted
	// from the original document, which provides a precise and contextually
	// relevant answer to the search query. If the number of matching answers is
	// less than the `max_extractive_answer_count`, return all of the answers.
	// Otherwise, return the `max_extractive_answer_count`. At most five answers
	// are returned for each SearchResult.
	MaxExtractiveAnswerCount int64 `json:"maxExtractiveAnswerCount,omitempty"`
	// MaxExtractiveSegmentCount: The max number of extractive segments returned in
	// each search result. Only applied if the DataStore is set to
	// DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is
	// SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from
	// the original document that is relevant to the search query, and, in general,
	// more verbose than an extractive answer. The segment could then be used as
	// input for LLMs to generate summaries and answers. If the number of matching
	// segments is less than `max_extractive_segment_count`, return all of the
	// segments. Otherwise, return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int64 `json:"maxExtractiveSegmentCount,omitempty"`
	// NumNextSegments: Return at most `num_next_segments` segments after each
	// selected segments.
	NumNextSegments int64 `json:"numNextSegments,omitempty"`
	// NumPreviousSegments: Specifies whether to also include the adjacent from
	// each selected segments. Return at most `num_previous_segments` segments
	// before each selected segments.
	NumPreviousSegments int64 `json:"numPreviousSegments,omitempty"`
	// ReturnExtractiveSegmentScore: Specifies whether to return the confidence
	// score from the extractive segments in each search result. This feature is
	// available only for new or allowlisted data stores. To allowlist your data
	// store, contact your Customer Engineer. The default value is `false`.
	ReturnExtractiveSegmentScore bool `json:"returnExtractiveSegmentScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxExtractiveAnswerCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxExtractiveAnswerCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec: A
// specification for configuring snippets in a search response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec struct {
	// MaxSnippetCount: [DEPRECATED] This field is deprecated. To control snippet
	// return, use `return_snippet` field. For backwards compatibility, we will
	// return snippet if max_snippet_count > 0.
	MaxSnippetCount int64 `json:"maxSnippetCount,omitempty"`
	// ReferenceOnly: [DEPRECATED] This field is deprecated and will have no affect
	// on the snippet.
	ReferenceOnly bool `json:"referenceOnly,omitempty"`
	// ReturnSnippet: If `true`, then return snippet. If no snippet can be
	// generated, we return "No snippet is available for this page." A
	// `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be
	// returned.
	ReturnSnippet bool `json:"returnSnippet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxSnippetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxSnippetCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec: A
// specification for configuring a summary returned in a search response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec struct {
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No summary is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating summaries for adversarial queries and return fallback
	// messages instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreNonSummarySeekingQuery: Specifies whether to filter out queries that
	// are not summary-seeking. The default value is `false`. Google employs
	// search-query classification to detect summary-seeking queries. No summary is
	// returned if the search query is classified as a non-summary seeking query.
	// For example, `why is the sky blue` and `Who is the best soccer player in the
	// world?` are summary-seeking queries, but `SFO airport` and `world cup 2026`
	// are not. They are most likely navigational queries. If this field is set to
	// `true`, we skip generating summaries for non-summary seeking queries and
	// return fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `json:"ignoreNonSummarySeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citations in the summary. The
	// default value is `false`. When this field is set to `true`, summaries
	// include in-line citation numbers. Example summary including citations:
	// BigQuery is Google Cloud's fully managed and completely serverless
	// enterprise data warehouse [1]. BigQuery supports all data types, works
	// across clouds, and has built-in machine learning and business intelligence,
	// all within a unified platform [2, 3]. The citation numbers refer to the
	// returned search results and are 1-indexed. For example, [1] means that the
	// sentence is attributed to the first search result. [2, 3] means that the
	// sentence is attributed to both the second and third search results.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// LanguageCode: Language code for Summary. Use language tags defined by BCP47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelPromptSpec: If specified, the spec will be used to modify the prompt
	// provided to the LLM.
	ModelPromptSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec `json:"modelPromptSpec,omitempty"`
	// ModelSpec: If specified, the spec will be used to modify the model
	// specification provided to the LLM.
	ModelSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec `json:"modelSpec,omitempty"`
	// SummaryResultCount: The number of top results to generate the summary from.
	// If the number of results returned is less than `summaryResultCount`, the
	// summary is generated from all of the results. At most 10 results for
	// documents mode, or 50 for chunks mode, can be used to generate a summary.
	// The chunks mode is used when
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	SummaryResultCount int64 `json:"summaryResultCount,omitempty"`
	// UseSemanticChunks: If true, answer will be generated from most relevant
	// chunks from top search results. This feature will improve summary quality.
	// Note that with this feature enabled, not all top search results will be
	// referenced and included in the reference list, so the citation source index
	// only points to the search results listed in the reference list.
	UseSemanticChunks bool `json:"useSemanticChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPro
// mptSpec: Specification of the prompt to use with the model.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec struct {
	// Preamble: Text at the beginning of the prompt that instructs the assistant.
	// Examples are available in the user guide.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpe
// c: Specification of the model.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec struct {
	// Version: The model version used to generate the summary. Supported values
	// are: * `stable`: string. Default value when no value is specified. Uses a
	// generally available, fine-tuned model. For more information, see Answer
	// generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	// * `preview`: string. (Public preview) Uses a preview model. For more
	// information, see Answer generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec: A struct to define
// data stores to filter on in a search call and configurations for those data
// stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
type GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec struct {
	// DataStore: Required. Full resource name of DataStore, such as
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`.
	DataStore string `json:"dataStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestFacetSpec: A facet specification to
// perform faceted search.
type GoogleCloudDiscoveryengineV1SearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If set to
	// true, the position of this facet among all facets in the response is
	// determined automatically. If dynamic facets are enabled, it is ordered
	// together. If set to false, the position of this facet in the response is the
	// same as in the request, and it is ranked before the facets with dynamic
	// position enable and all dynamic facets. For example, you may always want to
	// have rating facet returned in the response, but it's not necessarily to
	// always display the rating facet at the top. In that case, you can set
	// enable_dynamic_position to true so that the position of rating facet in
	// response is determined automatically. Another example, assuming you have the
	// following facets in the request: * "rating", enable_dynamic_position = true
	// * "price", enable_dynamic_position = false * "brands",
	// enable_dynamic_position = false And also you have a dynamic facets enabled,
	// which generates a facet `gender`. Then the final order of the facets in the
	// response can be ("price", "brands", "rating", "gender") or ("price",
	// "brands", "gender", "rating") depends on how API orders "gender" and
	// "rating" facets. However, notice that "price" and "brands" are always ranked
	// at first and second position because their enable_dynamic_position is false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`
	// ExcludedFilterKeys: List of keys to exclude when faceting. By default,
	// FacetKey.key is not excluded from the filter unless it is listed in this
	// field. Listing a facet key in this field allows its values to appear as
	// facet results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned. For example, suppose
	// there are 100 documents with the color facet "Red" and 200 documents with
	// the color facet "Blue". A query containing the filter "color:ANY("Red")" and
	// having "color" as FacetKey.key would by default return only "Red" documents
	// in the search results, and also return "Red" with count 100 as the only
	// color facet. Although there are also blue documents available, "Blue" would
	// not be shown as an available facet value. If "color" is listed in
	// "excludedFilterKeys", then the query returns the facet values "Red" with
	// count 100 and "Blue" with count 200, because the "color" key is now excluded
	// from the filter. Because this field doesn't affect search results, the
	// search results are still correctly filtered to return only "Red" documents.
	// A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error
	// is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`
	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`
	// Limit: Maximum facet values that are returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values above
	// 300 are coerced to 300. For aggregation in healthcare search, when the
	// [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden
	// to 10,000 internally, regardless of the value set here. If this field is
	// negative, an `INVALID_ARGUMENT` is returned.
	Limit int64 `json:"limit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableDynamicPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestFacetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey: Specifies how a
// facet is computed.
type GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey struct {
	// CaseInsensitive: True to make facet keys case insensitive when getting
	// faceting values with prefixes or contains; false otherwise.
	CaseInsensitive bool `json:"caseInsensitive,omitempty"`
	// Contains: Only get facet values that contain the given strings. For example,
	// suppose "category" has three values "Action > 2022", "Action > 2021" and
	// "Sci-Fi > 2022". If set "contains" to "2022", the "category" facet only
	// contains "Action > 2022" and "Sci-Fi > 2022". Only supported on textual
	// fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`
	// Intervals: Set only if values should be bucketed into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*GoogleCloudDiscoveryengineV1Interval `json:"intervals,omitempty"`
	// Key: Required. Supported textual and numerical facet keys in Document
	// object, over which the facet values are computed. Facet key is
	// case-sensitive.
	Key string `json:"key,omitempty"`
	// OrderBy: The order in which documents are returned. Allowed values are: *
	// "count desc", which means order by SearchResponse.Facet.values.count
	// descending. * "value desc", which means order by
	// SearchResponse.Facet.values.value descending. Only applies to textual
	// facets. If not set, textual values are sorted in natural order
	// (https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are
	// sorted in the order given by FacetSpec.FacetKey.intervals.
	OrderBy string `json:"orderBy,omitempty"`
	// Prefixes: Only get facet values that start with the given string prefix. For
	// example, suppose "category" has three values "Action > 2022", "Action >
	// 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the "category"
	// facet only contains "Action > 2022" and "Action > 2021". Only supported on
	// textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`
	// RestrictedValues: Only get facet for the given restricted values. Only
	// supported on textual fields. For example, suppose "category" has three
	// values "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
	// "restricted_values" to "Action > 2022", the "category" facet only contains
	// "Action > 2022". Only supported on textual fields. Maximum is 10.
	RestrictedValues []string `json:"restrictedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseInsensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseInsensitive") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestImageQuery: Specifies the image
// query input.
type GoogleCloudDiscoveryengineV1SearchRequestImageQuery struct {
	// ImageBytes: Base64 encoded image bytes. Supported image formats: JPEG, PNG,
	// and BMP.
	ImageBytes string `json:"imageBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestImageQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestImageQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec: Specification
// to determine under which conditions query expansion should occur.
type GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur. Default
	// to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query expansion condition. In this
	// case, server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disabled query expansion. Only the exact search query is
	// used, even if SearchResponse.total_size is zero.
	//   "AUTO" - Automatic query expansion built by the Search API.
	Condition string `json:"condition,omitempty"`
	// PinUnexpandedResults: Whether to pin unexpanded results. If this field is
	// set to true, unexpanded products are always at the top of the search
	// results, followed by the expanded results.
	PinUnexpandedResults bool `json:"pinUnexpandedResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec: Specification
// for search as you type in search requests.
type GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec struct {
	// Condition: The condition under which search as you type should occur.
	// Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disables Search As You Type.
	//   "ENABLED" - Enables Search As You Type.
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestSessionSpec: Session specification.
// Multi-turn Search feature is currently at private GA stage. Please use
// v1alpha or v1beta version instead before we launch this feature to public
// GA. Or ask for allowlisting through Google Support team.
type GoogleCloudDiscoveryengineV1SearchRequestSessionSpec struct {
	// QueryId: If set, the search result gets stored to the "turn" specified by
	// this query ID. Example: Let's say the session looks like this: session {
	// name: ".../sessions/xxx" turns { query { text: "What is foo?" query_id:
	// ".../questions/yyy" } answer: "Foo is ..." } turns { query { text: "How
	// about bar then?" query_id: ".../questions/zzz" } } } The user can call
	// /search API with a request like this: session: ".../sessions/xxx"
	// session_spec { query_id: ".../questions/zzz" } Then, the API stores the
	// search result, associated with the last turn. The stored search result can
	// be used by a subsequent /answer API call (with the session ID and the query
	// ID specified). Also, it is possible to call /search and /answer in parallel
	// with the same session ID & query ID.
	QueryId string `json:"queryId,omitempty"`
	// SearchResultPersistenceCount: The number of top search results to persist.
	// The persisted search results can be used for the subsequent /answer api
	// call. This field is simliar to the `summary_result_count` field in
	// SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count. At most 10
	// results for documents mode, or 50 for chunks mode.
	SearchResultPersistenceCount int64 `json:"searchResultPersistenceCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestSessionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestSessionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec: The
// specification for query spell correction.
type GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec struct {
	// Mode: The mode under which spell correction replaces the original search
	// query. Defaults to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified spell correction mode. In this case,
	// server behavior defaults to Mode.AUTO.
	//   "SUGGESTION_ONLY" - Search API tries to find a spelling suggestion. If a
	// suggestion is found, it is put in the SearchResponse.corrected_query. The
	// spelling suggestion won't be used as the search query.
	//   "AUTO" - Automatic spell correction built by the Search API. Search will
	// be based on the corrected query if found.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponse: Response message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1SearchResponse struct {
	// AttributionToken: A unique search token. This should be included in the
	// UserEvent logs resulting from this search, which enables accurate
	// attribution of search model performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CorrectedQuery: Contains the spell corrected query, if found. If the spell
	// correction type is AUTOMATIC, then the search results are based on
	// corrected_query. Otherwise the original query is used for search.
	CorrectedQuery string `json:"correctedQuery,omitempty"`
	// Facets: Results of facets requested by user.
	Facets []*GoogleCloudDiscoveryengineV1SearchResponseFacet `json:"facets,omitempty"`
	// NextPageToken: A token that can be sent as SearchRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QueryExpansionInfo: Query expansion information for the returned results.
	QueryExpansionInfo *GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo `json:"queryExpansionInfo,omitempty"`
	// RedirectUri: The URI of a customer-defined redirect page. If redirect action
	// is triggered, no search is performed, and only redirect_uri and
	// attribution_token are set in the response.
	RedirectUri string `json:"redirectUri,omitempty"`
	// Results: A list of matched documents. The order represents the ranking.
	Results []*GoogleCloudDiscoveryengineV1SearchResponseSearchResult `json:"results,omitempty"`
	// SessionInfo: Session information. Only set if SearchRequest.session is
	// provided. See its description for more details.
	SessionInfo *GoogleCloudDiscoveryengineV1SearchResponseSessionInfo `json:"sessionInfo,omitempty"`
	// Summary: A summary as part of the search results. This field is only
	// returned if SearchRequest.ContentSearchSpec.summary_spec is set.
	Summary *GoogleCloudDiscoveryengineV1SearchResponseSummary `json:"summary,omitempty"`
	// TotalSize: The estimated total count of matched items irrespective of
	// pagination. The count of results returned by pagination may be less than the
	// total_size that matches.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseFacet: A facet result.
type GoogleCloudDiscoveryengineV1SearchResponseFacet struct {
	// DynamicFacet: Whether the facet is dynamically generated.
	DynamicFacet bool `json:"dynamicFacet,omitempty"`
	// Key: The key for this facet. For example, "colors" or "price". It
	// matches SearchRequest.FacetSpec.FacetKey.key.
	Key string `json:"key,omitempty"`
	// Values: The facet values for this field.
	Values []*GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicFacet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicFacet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseFacet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseFacet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue: A facet value
// which contains value names and their count.
type GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue struct {
	// Count: Number of items that have this facet value.
	Count int64 `json:"count,omitempty,string"`
	// Interval: Interval value for a facet, such as 10, 20) for facet "price". It
	// matches [SearchRequest.FacetSpec.FacetKey.intervals.
	Interval *GoogleCloudDiscoveryengineV1Interval `json:"interval,omitempty"`
	// Value: Text value of a facet, such as "Black" for facet "colors".
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo: Information
// describing query expansion including whether expansion has occurred.
type GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo struct {
	// ExpandedQuery: Bool describing whether query expansion has occurred.
	ExpandedQuery bool `json:"expandedQuery,omitempty"`
	// PinnedResultCount: Number of pinned results. This field will only be set
	// when expansion happens and
	// SearchRequest.QueryExpansionSpec.pin_unexpanded_results is set to true.
	PinnedResultCount int64 `json:"pinnedResultCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ExpandedQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpandedQuery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSearchResult: Represents the
// search results.
type GoogleCloudDiscoveryengineV1SearchResponseSearchResult struct {
	// Chunk: The chunk data in the search response if the
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	Chunk *GoogleCloudDiscoveryengineV1Chunk `json:"chunk,omitempty"`
	// Document: The document data snippet in the search response. Only fields that
	// are marked as `retrievable` are populated.
	Document *GoogleCloudDiscoveryengineV1Document `json:"document,omitempty"`
	// Id: Document.id of the searched Document.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSessionInfo: Information about the
// session.
type GoogleCloudDiscoveryengineV1SearchResponseSessionInfo struct {
	// Name: Name of the session. If the auto-session mode is used (when
	// SearchRequest.session ends with "-"), this field holds the newly generated
	// session name.
	Name string `json:"name,omitempty"`
	// QueryId: Query ID that corresponds to this search API call. One session can
	// have multiple turns, each with a unique query ID. By specifying the session
	// name and this query ID in the Answer API call, the answer generation happens
	// in the context of the search results from this search call.
	QueryId string `json:"queryId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummary: Summary of the top N
// search results specified by the summary spec.
type GoogleCloudDiscoveryengineV1SearchResponseSummary struct {
	// SafetyAttributes: A collection of Safety Attribute categories and their
	// associated confidence scores.
	SafetyAttributes *GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes `json:"safetyAttributes,omitempty"`
	// SummarySkippedReasons: Additional summary-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "SUMMARY_SKIPPED_REASON_UNSPECIFIED" - Default value. The summary skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case. Only
	// populated when SummarySpec.ignore_adversarial_query is set to `true`.
	//   "NON_SUMMARY_SEEKING_QUERY_IGNORED" - The non-summary seeking query
	// ignored case. Only populated when
	// SummarySpec.ignore_non_summary_seeking_query is set to `true`.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the summary if there are no high-relevance search results. For
	// example, the data store contains facts about company A but the user query is
	// asking questions about company B.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the summary if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "LLM_ADDON_NOT_ENABLED" - The LLM addon not enabled case. Google skips the
	// summary if the LLM addon is not enabled.
	SummarySkippedReasons []string `json:"summarySkippedReasons,omitempty"`
	// SummaryText: The summary content.
	SummaryText string `json:"summaryText,omitempty"`
	// SummaryWithMetadata: Summary with metadata information.
	SummaryWithMetadata *GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata `json:"summaryWithMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SafetyAttributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SafetyAttributes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation: Citation info for
// a segment.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in
	// bytes/unicode.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata: Citation
// metadata.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata struct {
	// Citations: Citations for segments.
	Citations []*GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource: Citation
// source.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource struct {
	// ReferenceIndex: Document reference index from
	// SummaryWithMetadata.references. It is 0-indexed and the value will be zero
	// if the reference_index is not set explicitly.
	ReferenceIndex int64 `json:"referenceIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ReferenceIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryReference: Document
// reference.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryReference struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent `json:"chunkContents,omitempty"`
	// Document: Required. Document.name of the document. Full resource name of the
	// referenced document, in the format
	// `projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*`.
	Document string `json:"document,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Cloud Storage or HTTP uri for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent:
// Chunk content.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes: Safety
// Attribute categories and their associated confidence scores.
type GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes struct {
	// Categories: The display names of Safety Attribute categories associated with
	// the generated content. Order matches the Scores.
	Categories []string `json:"categories,omitempty"`
	// Scores: The confidence scores of the each category, higher value means
	// higher confidence. Order matches the Categories.
	Scores []float64 `json:"scores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata:
// Summary with metadata information.
type GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata struct {
	// CitationMetadata: Citation metadata for given summary.
	CitationMetadata *GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata `json:"citationMetadata,omitempty"`
	// References: Document References.
	References []*GoogleCloudDiscoveryengineV1SearchResponseSummaryReference `json:"references,omitempty"`
	// Summary: Summary text with no citation information.
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Session: External session proto definition.
type GoogleCloudDiscoveryengineV1Session struct {
	// EndTime: Output only. The time the session finished.
	EndTime string `json:"endTime,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*`
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the session started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the session.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is unspecified.
	//   "IN_PROGRESS" - The session is currently open.
	State string `json:"state,omitempty"`
	// Turns: Turns.
	Turns []*GoogleCloudDiscoveryengineV1SessionTurn `json:"turns,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Session) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Session
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SessionTurn: Represents a turn, including a
// query from the user and a answer from service.
type GoogleCloudDiscoveryengineV1SessionTurn struct {
	// Answer: The resource name of the answer to the user query. Only set if the
	// answer generation (/answer API call) happened in this turn.
	Answer string `json:"answer,omitempty"`
	// Query: The user query.
	Query *GoogleCloudDiscoveryengineV1Query `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SessionTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SessionTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SiteSearchEngine: SiteSearchEngine captures
// DataStore level site search persisting configurations. It is a singleton
// value per data store.
type GoogleCloudDiscoveryengineV1SiteSearchEngine struct {
	// Name: The fully qualified resource name of the site search engine. Format:
	// `projects/*/locations/*/dataStores/*/siteSearchEngine`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SiteSearchEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SiteSearchEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SiteVerificationInfo: Verification information
// for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1SiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the ownership and
	// validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification failed.
	//   "EXEMPTED" - Site exempt from verification, e.g., a public website that
	// opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`
	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteVerificationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SiteVerificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SpannerSource: The Spanner source for importing
// data
type GoogleCloudDiscoveryengineV1SpannerSource struct {
	// DatabaseId: Required. The database ID of the source Spanner table.
	DatabaseId string `json:"databaseId,omitempty"`
	// EnableDataBoost: Whether to apply data boost on Spanner export. Enabling
	// this option will incur additional cost. More info can be found here
	// (https://cloud.google.com/spanner/docs/databoost/databoost-overview#billing_and_quotas).
	EnableDataBoost bool `json:"enableDataBoost,omitempty"`
	// InstanceId: Required. The instance ID of the source Spanner table.
	InstanceId string `json:"instanceId,omitempty"`
	// ProjectId: The project ID that the Spanner source is in with a length limit
	// of 128 characters. If not specified, inherits the project ID from the parent
	// request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The table name of the Spanner database that needs to be
	// imported.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SpannerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SpannerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SuggestionDenyListEntry: Suggestion deny list
// entry identifying the phrase to block from suggestions and the applied
// operation for the phrase.
type GoogleCloudDiscoveryengineV1SuggestionDenyListEntry struct {
	// BlockPhrase: Required. Phrase to block from suggestions served. Can be
	// maximum 125 characters.
	BlockPhrase string `json:"blockPhrase,omitempty"`
	// MatchOperator: Required. The match operator to apply for this phrase.
	// Whether to block the exact phrase, or block any suggestions containing this
	// phrase.
	//
	// Possible values:
	//   "MATCH_OPERATOR_UNSPECIFIED" - Default value. Should not be used
	//   "EXACT_MATCH" - If the suggestion is an exact match to the block_phrase,
	// then block it.
	//   "CONTAINS" - If the suggestion contains the block_phrase, then block it.
	MatchOperator string `json:"matchOperator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockPhrase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockPhrase") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SuggestionDenyListEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SuggestionDenyListEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1TargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated to
	// include all pages whose address contains the provided_uri_pattern. If set to
	// true, an uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to generate the
	// URI pattern to be used by the search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`
	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1TargetSiteFailureReason `json:"failureReason,omitempty"`
	// GeneratedUriPattern: Output only. This is system-generated based on the
	// provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`
	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be picked up
	// by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to be
	// deleted. This is a transitioning state which will resulted in either: 1.
	// target site deleted if unindexing is successful; 2. state reverts to
	// SUCCEEDED if the unindexing fails.
	IndexingStatus string `json:"indexingStatus,omitempty"`
	// Name: Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`
	// ProvidedUriPattern: Required. Input only. The user provided URI pattern from
	// which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`
	// RootDomainUri: Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `json:"rootDomainUri,omitempty"`
	// SiteVerificationInfo: Output only. Site ownership and validity verification
	// status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1SiteVerificationInfo `json:"siteVerificationInfo,omitempty"`
	// Type: The type of the target site, e.g., whether the site is to be included
	// or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server behavior
	// defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSiteFailureReason: Site search indexing
// failure reasons.
type GoogleCloudDiscoveryengineV1TargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuotaFailure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSiteFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure: Failed due
// to insufficient quota.
type GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure struct {
	// TotalRequiredQuota: This number is an estimation on how much total quota
	// this project needs to successfully complete indexing.
	TotalRequiredQuota int64 `json:"totalRequiredQuota,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalRequiredQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalRequiredQuota") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TextInput: Defines text input.
type GoogleCloudDiscoveryengineV1TextInput struct {
	// Context: Conversation context of the input.
	Context *GoogleCloudDiscoveryengineV1ConversationContext `json:"context,omitempty"`
	// Input: Text input.
	Input string `json:"input,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TransactionInfo: A transaction represents the
// entire purchase transaction.
type GoogleCloudDiscoveryengineV1TransactionInfo struct {
	// Cost: All the costs associated with the products. These can be manufacturing
	// costs, shipping expenses not borne by the end user, or any other costs, such
	// that: * Profit = value - tax - cost
	Cost float64 `json:"cost,omitempty"`
	// Currency: Required. Currency code. Use three-character ISO-4217 code.
	Currency string `json:"currency,omitempty"`
	// DiscountValue: The total discount(s) value applied to this transaction. This
	// figure should be excluded from TransactionInfo.value For example, if a user
	// paid TransactionInfo.value amount, then nominal (pre-discount) value of the
	// transaction is the sum of TransactionInfo.value and
	// TransactionInfo.discount_value This means that profit is calculated the same
	// way, regardless of the discount value, and that
	// TransactionInfo.discount_value can be larger than TransactionInfo.value: *
	// Profit = value - tax - cost
	DiscountValue float64 `json:"discountValue,omitempty"`
	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`
	// TransactionId: The transaction ID with a length limit of 128 characters.
	TransactionId string `json:"transactionId,omitempty"`
	// Value: Required. Total non-zero value associated with the transaction. This
	// value may include shipping, tax, or other adjustments to the total value
	// that you want to include.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cost") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TransactionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TransactionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1TransactionInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1TransactionInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		DiscountValue gensupport.JSONFloat64 `json:"discountValue"`
		Tax           gensupport.JSONFloat64 `json:"tax"`
		Value         gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.DiscountValue = float64(s1.DiscountValue)
	s.Tax = float64(s1.Tax)
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudDiscoveryengineV1UpdateSchemaMetadata: Metadata for UpdateSchema
// LRO.
type GoogleCloudDiscoveryengineV1UpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.UpdateTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UserEvent: UserEvent captures all metadata
// information Discovery Engine API needs to know about how end users interact
// with your website.
type GoogleCloudDiscoveryengineV1UserEvent struct {
	// Attributes: Extra user event features to include in the recommendation
	// model. These attributes must NOT contain data that needs to be parsed or
	// processed further, e.g. JSON or other encodings. If you provide custom
	// attributes for ingested user events, also include them in the user events
	// that you associate with prediction requests. Custom attribute formatting
	// must be consistent between imported events and events provided with
	// prediction requests. This lets the Discovery Engine API use those custom
	// attributes when training models and serving predictions, which helps improve
	// recommendation quality. This field needs to pass all below criteria,
	// otherwise an `INVALID_ARGUMENT` error is returned: * The key must be a UTF-8
	// encoded string with a length limit of 5,000 characters. * For text
	// attributes, at most 400 values are allowed. Empty values are not allowed.
	// Each value must be a UTF-8 encoded string with a length limit of 256
	// characters. * For number attributes, at most 400 values are allowed. For
	// product recommendations, an example of extra user information is
	// `traffic_channel`, which is how a user arrives at the site. Users can arrive
	// at the site by coming to the site directly, coming through Google search, or
	// in other ways.
	Attributes map[string]GoogleCloudDiscoveryengineV1CustomAttribute `json:"attributes,omitempty"`
	// AttributionToken: Token to attribute an API response to user action(s) to
	// trigger the event. Highly recommended for user events that are the result of
	// RecommendationService.Recommend. This field enables accurate attribution of
	// recommendation model performance. The value must be one of: *
	// RecommendResponse.attribution_token for events that are the result of
	// RecommendationService.Recommend. * SearchResponse.attribution_token for
	// events that are the result of SearchService.Search. This token enables us to
	// accurately attribute page view or conversion completion back to the event
	// and the particular predict response containing this clicked/purchased
	// product. If user clicks on product K in the recommendation results, pass
	// RecommendResponse.attribution_token as a URL parameter to product K's page.
	// When recording events on product K's page, log the
	// RecommendResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CompletionInfo: CompletionService.CompleteQuery details related to the
	// event. This field should be set for `search` event when autocomplete
	// function is enabled and the user clicks a suggestion for search.
	CompletionInfo *GoogleCloudDiscoveryengineV1CompletionInfo `json:"completionInfo,omitempty"`
	// DataStore: The DataStore resource full name, of the form
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. Optional. Only required for user events whose data
	// store can't by determined by UserEvent.engine or UserEvent.documents. If
	// data store is set in the parent of write/import/collect user event requests,
	// this field can be omitted.
	DataStore string `json:"dataStore,omitempty"`
	// DirectUserRequest: Should set to true if the request is made directly from
	// the end user, in which case the UserEvent.user_info.user_agent can be
	// populated from the HTTP request. This flag should be set only if the API
	// request is made directly from the end user such as a mobile app (and not if
	// a gateway or a server is processing and pushing the user events). This
	// should not be set when using the JavaScript tag in
	// UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`
	// Documents: List of Documents associated with this user event. This field is
	// optional except for the following event types: * `view-item` * `add-to-cart`
	// * `purchase` * `media-play` * `media-complete` In a `search` event, this
	// field represents the documents returned to the end user on the current page
	// (the end user may have not finished browsing the whole page yet). When a new
	// page is returned to the end user, after pagination/filtering/ordering even
	// for the same query, a new `search` event with different UserEvent.documents
	// is desired.
	Documents []*GoogleCloudDiscoveryengineV1DocumentInfo `json:"documents,omitempty"`
	// Engine: The Engine resource name, in the form of
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/
	// {engine_id}`. Optional. Only required for Engine produced user events. For
	// example, user events from blended search.
	Engine string `json:"engine,omitempty"`
	// EventTime: Only required for UserEventService.ImportUserEvents method.
	// Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`
	// EventType: Required. User event type. Allowed values are: Generic values: *
	// `search`: Search for Documents. * `view-item`: Detailed page view of a
	// Document. * `view-item-list`: View of a panel or ordered list of Documents.
	// * `view-home-page`: View of the home page. * `view-category-page`: View of a
	// category page, e.g. Home > Men > Jeans Retail-related values: *
	// `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping *
	// `purchase`: Purchase an item(s) Media-related values: * `media-play`:
	// Start/resume watching a video, playing a song, etc. * `media-complete`:
	// Finished or stopped midway through a video, song, etc.
	EventType string `json:"eventType,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. One example is for `search` events, the associated SearchRequest
	// may contain a filter expression in SearchRequest.filter conforming to
	// https://google.aip.dev/160#filtering. Similarly, for `view-item-list` events
	// that are generated from a RecommendRequest, this field may be populated
	// directly from RecommendRequest.filter conforming to
	// https://google.aip.dev/160#filtering. The value must be a UTF-8 encoded
	// string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	Filter string `json:"filter,omitempty"`
	// MediaInfo: Media-specific info.
	MediaInfo *GoogleCloudDiscoveryengineV1MediaInfo `json:"mediaInfo,omitempty"`
	// PageInfo: Page metadata such as categories and other critical information
	// for certain event types such as `view-category-page`.
	PageInfo *GoogleCloudDiscoveryengineV1PageInfo `json:"pageInfo,omitempty"`
	// Panel: Panel metadata associated with this user event.
	Panel *GoogleCloudDiscoveryengineV1PanelInfo `json:"panel,omitempty"`
	// PromotionIds: The promotion IDs if this is an event associated with
	// promotions. Currently, this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`
	// SearchInfo: SearchService.Search details related to the event. This field
	// should be set for `search` event.
	SearchInfo *GoogleCloudDiscoveryengineV1SearchInfo `json:"searchInfo,omitempty"`
	// SessionId: A unique identifier for tracking a visitor session with a length
	// limit of 128 bytes. A session is an aggregation of an end user behavior in a
	// time span. A general guideline to populate the session_id: 1. If user has no
	// activity for 30 min, a new session_id should be assigned. 2. The session_id
	// should be unique across users, suggest use uuid or add
	// UserEvent.user_pseudo_id as prefix.
	SessionId string `json:"sessionId,omitempty"`
	// TagIds: A list of identifiers for the independent experiment groups this
	// user event belongs to. This is used to distinguish between user events
	// associated with different experiment setups.
	TagIds []string `json:"tagIds,omitempty"`
	// TransactionInfo: The transaction metadata (if any) associated with this user
	// event.
	TransactionInfo *GoogleCloudDiscoveryengineV1TransactionInfo `json:"transactionInfo,omitempty"`
	// UserInfo: Information about the end user.
	UserInfo *GoogleCloudDiscoveryengineV1UserInfo `json:"userInfo,omitempty"`
	// UserPseudoId: Required. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should be able
	// to uniquely identify a visitor on a single device. This unique identifier
	// should not change if the visitor log in/out of the website. Do not set the
	// field to the same fixed ID for different users. This mixes the event history
	// of those users together, which results in degraded model quality. The field
	// must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned. The field should not
	// contain PII or user-data. We recommend to use Google Analytics Client ID
	// (https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UserEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UserInfo: Information of an end user.
type GoogleCloudDiscoveryengineV1UserInfo struct {
	// UserAgent: User agent as included in the HTTP header. The field must be a
	// UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. This should not be set when using the
	// client side event reporting with GTM or JavaScript tag in
	// UserEventService.CollectUserEvent or if UserEvent.direct_user_request is
	// set.
	UserAgent string `json:"userAgent,omitempty"`
	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. Don't set for anonymous users. Always
	// use a hashed value for this ID. Don't set the field to the same fixed ID for
	// different users. This mixes the event history of those users together, which
	// results in degraded model quality. The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserAgent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAclConfig: Access Control Configuration.
type GoogleCloudDiscoveryengineV1alphaAclConfig struct {
	// IdpConfig: Identity provider config.
	IdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfig `json:"idpConfig,omitempty"`
	// Name: Immutable. The full resource name of the acl configuration. Format:
	// `projects/{project}/locations/{location}/aclConfig`. This field must be a
	// UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdpConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAclConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAclConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswer: Defines an answer.
type GoogleCloudDiscoveryengineV1alphaAnswer struct {
	// AnswerSkippedReasons: Additional answer-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "ANSWER_SKIPPED_REASON_UNSPECIFIED" - Default value. The answer skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED" - The non-answer seeking query ignored
	// case.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the answer if there are no high-relevance search results.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the answer if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// answer if there is no relevant content in the retrieved search results.
	AnswerSkippedReasons []string `json:"answerSkippedReasons,omitempty"`
	// AnswerText: The textual answer.
	AnswerText string `json:"answerText,omitempty"`
	// Citations: Citations.
	Citations []*GoogleCloudDiscoveryengineV1alphaAnswerCitation `json:"citations,omitempty"`
	// CompleteTime: Output only. Answer completed timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Answer creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*/answers/*`
	Name string `json:"name,omitempty"`
	// QueryUnderstandingInfo: Query understanding information.
	QueryUnderstandingInfo *GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo `json:"queryUnderstandingInfo,omitempty"`
	// References: References.
	References []*GoogleCloudDiscoveryengineV1alphaAnswerReference `json:"references,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// State: The state of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Answer generation is currently in progress.
	//   "FAILED" - Answer generation currently failed.
	//   "SUCCEEDED" - Answer generation has succeeded.
	State string `json:"state,omitempty"`
	// Steps: Answer generation steps.
	Steps []*GoogleCloudDiscoveryengineV1alphaAnswerStep `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerCitation: Citation info for a
// segment.
type GoogleCloudDiscoveryengineV1alphaAnswerCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1alphaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in bytes
	// (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerCitationSource: Citation source.
type GoogleCloudDiscoveryengineV1alphaAnswerCitationSource struct {
	// ReferenceId: ID of the citation source.
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo: Query
// understanding information.
type GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo struct {
	// QueryClassificationInfo: Query classification information.
	QueryClassificationInfo []*GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo `json:"queryClassificationInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificat
// ionInfo: Query classification information.
type GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo struct {
	// Positive: Classification output.
	Positive bool `json:"positive,omitempty"`
	// Type: Query classification type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Positive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Positive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReference: Reference.
type GoogleCloudDiscoveryengineV1alphaAnswerReference struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo `json:"chunkInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo: Chunk
// information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// RelevanceScore: Relevance score.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata:
// Document metadata.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo:
// Unstructured document information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent `json:"chunkContents,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunk
// Content: Chunk content.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStep: Step information.
type GoogleCloudDiscoveryengineV1alphaAnswerStep struct {
	// Actions: Actions.
	Actions []*GoogleCloudDiscoveryengineV1alphaAnswerStepAction `json:"actions,omitempty"`
	// Description: The description of the step.
	Description string `json:"description,omitempty"`
	// State: The state of the step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Step is currently in progress.
	//   "FAILED" - Step currently failed.
	//   "SUCCEEDED" - Step has succeeded.
	State string `json:"state,omitempty"`
	// Thought: The thought of the step.
	Thought string `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepAction: Action.
type GoogleCloudDiscoveryengineV1alphaAnswerStepAction struct {
	// Observation: Observation.
	Observation *GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation `json:"observation,omitempty"`
	// SearchAction: Search action.
	SearchAction *GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction `json:"searchAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Observation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Observation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation: Observation.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation struct {
	// SearchResults: Search results observed by the search action, it can be
	// snippets info or chunk info, depending on the citation type set by the user.
	SearchResults []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult struct {
	// ChunkInfo: If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// SnippetInfo: If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo `json:"snippetInfo,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It's populated from the struct data from the Document (code pointer:
	// http://shortn/_objzAfIiHq), or the Chunk in search result (code pointer:
	// http://shortn/_Ipo6KFFGBL).
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunk
// Info: Chunk information.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// RelevanceScore: Relevance score.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnipp
// etInfo: Snippet information.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo struct {
	// Snippet: Snippet content.
	Snippet string `json:"snippet,omitempty"`
	// SnippetStatus: Status of the snippet defined by the search team.
	SnippetStatus string `json:"snippetStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction: Search
// action.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction struct {
	// Query: The query to search.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.BatchCreateTargetSites operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse: Response
// message for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCondition: Defines circumstances to be
// checked before allowing a behavior
type GoogleCloudDiscoveryengineV1alphaCondition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1alphaConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Maximum of 10
	// query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1alphaConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConditionQueryTerm: Matcher for search
// request query
type GoogleCloudDiscoveryengineV1alphaConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1alphaConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControl: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1alphaControl struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig ids this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1alphaControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1alphaCondition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1alphaControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1alphaControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1alphaControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControl) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlBoostAction: Adjusts order of
// products in returned list.
type GoogleCloudDiscoveryengineV1alphaControlBoostAction struct {
	// Boost: Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaControlFilterAction: Specified which
// products may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1alphaControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlRedirectAction: Redirects a shopper
// to the provided URI.
type GoogleCloudDiscoveryengineV1alphaControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlSynonymsAction: Creates a set of
// terms that will act as synonyms of one another. Example: "happy" will also
// be considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1alphaControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata: Metadata related
// to the progress of the DataStoreService.CreateDataStore operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata: Metadata related to
// the progress of the EngineService.CreateEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata: Metadata for Create
// Schema LRO.
type GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.CreateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCustomTuningModel: Metadata that describes
// a custom tuned model.
type GoogleCloudDiscoveryengineV1alphaCustomTuningModel struct {
	// CreateTime: Timestamp the Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The display name of the model.
	DisplayName string `json:"displayName,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelState: The state that the model is in (e.g.`TRAINING` or
	// `TRAINING_FAILED`).
	//
	// Possible values:
	//   "MODEL_STATE_UNSPECIFIED" - Default value.
	//   "TRAINING_PAUSED" - The model is in a paused training state.
	//   "TRAINING" - The model is currently training.
	//   "TRAINING_COMPLETE" - The model has successfully completed training.
	//   "READY_FOR_SERVING" - The model is ready for serving.
	//   "TRAINING_FAILED" - The model training failed.
	//   "NO_IMPROVEMENT" - The model training finished successfully but metrics
	// did not improve.
	ModelState string `json:"modelState,omitempty"`
	// ModelVersion: The version of the model.
	ModelVersion int64 `json:"modelVersion,omitempty,string"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/customTuningModels/{custom_tuning_model}` model must be
	// an alpha-numerical string with limit of 40 characters.
	Name string `json:"name,omitempty"`
	// TrainingStartTime: Timestamp the model training was initiated.
	TrainingStartTime string `json:"trainingStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCustomTuningModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCustomTuningModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataStore: DataStore captures global
// settings and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1alphaDataStore struct {
	// AclEnabled: Immutable. Whether data in the DataStore has ACL information. If
	// set to `true`, the source data must have ACL. ACL will be ingested when data
	// is ingested by DocumentService.ImportDocuments methods. When ACL is enabled
	// for the DataStore, Document can't be accessed by calling
	// DocumentService.GetDocument or DocumentService.ListDocuments. Currently ACL
	// is only supported in `GENERIC` industry vertical with non-`PUBLIC_WEBSITE`
	// content config.
	AclEnabled bool `json:"aclEnabled,omitempty"`
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema asscociated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// IdpConfig: Output only. Data store level identity provider config.
	IdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfig `json:"idpConfig,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// LanguageInfo: Language info for DataStore.
	LanguageInfo *GoogleCloudDiscoveryengineV1alphaLanguageInfo `json:"languageInfo,omitempty"`
	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1alphaSchema `json:"startingSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AclEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AclEnabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata: Metadata related
// to the progress of the DataStoreService.DeleteDataStore operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata: Metadata related to
// the progress of the EngineService.DeleteEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.DeleteTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig: A singleton
// resource of DataStore. It's empty when DataStore is created, which defaults
// to digital parser. The first call to
// DataStoreService.UpdateDocumentProcessingConfig method will initialize the
// config.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayout
// BasedChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig:
// Related configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigital
// ParsingConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutP
// arsingConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrPars
// ingConfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaEngine: Metadata that describes the
// training and serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1alphaEngine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1alphaEngineCommonConfig `json:"commonConfig,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// IndustryVertical: The industry vertical that the engine registers. The
	// restriction of the Engine industry vertical is based on DataStore: If
	// unspecified, default to `GENERIC`. Vertical on Engine has to match vertical
	// of the DataStore linked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// MediaRecommendationEngineConfig: Configurations for the Media Engine. Only
	// applicable on the data stores with solution_type
	// SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
	MediaRecommendationEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig `json:"mediaRecommendationEngineConfig,omitempty"`
	// Name: Immutable. The fully qualified resource name of the engine. This field
	// must be a UTF-8 encoded string with a length limit of 1024 characters.
	// Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/engi
	// nes/{engine}` engine should be 1-63 characters, and valid characters are
	// /a-z0-9*/. Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// RecommendationMetadata: Output only. Additional information of a
	// recommendation engine. Only applicable if solution_type is
	// SOLUTION_TYPE_RECOMMENDATION.
	RecommendationMetadata *GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata `json:"recommendationMetadata,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SimilarDocumentsConfig: Additional config specs for a `similar-items`
	// engine.
	SimilarDocumentsConfig *GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig `json:"similarDocumentsConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatEngineConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig: Configurations for
// a Chat Engine.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata: Additional
// information of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineCommonConfig: Common configurations
// for an Engine.
type GoogleCloudDiscoveryengineV1alphaEngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig:
// Additional config specs for a Media Recommendation engine.
type GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig struct {
	// OptimizationObjective: The optimization objective. e.g., `cvr`. This field
	// together with optimization_objective describe engine metadata to use to
	// control engine training and serving. Currently supported values: `ctr`,
	// `cvr`. If not specified, we choose default based on engine type. Default
	// depends on type of recommendation: `recommended-for-you` => `ctr`
	// `others-you-may-like` => `ctr`
	OptimizationObjective string `json:"optimizationObjective,omitempty"`
	// OptimizationObjectiveConfig: Name and value of the custom threshold for cvr
	// optimization_objective. For target_field `watch-time`, target_field_value
	// must be an integer value indicating the media progress time in seconds
	// between (0, 86400] (excludes 0, includes 86400) (e.g., 90). For target_field
	// `watch-percentage`, the target_field_value must be a valid float value
	// between (0, 1.0] (excludes 0, includes 1.0) (e.g., 0.5).
	OptimizationObjectiveConfig *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig `json:"optimizationObjectiveConfig,omitempty"`
	// TrainingState: The training state that the engine is in (e.g. `TRAINING` or
	// `PAUSED`). Since part of the cost of running the service is frequency of
	// training - this can be used to determine when to train engine in order to
	// control cost. If not specified: the default value for `CreateEngine` method
	// is `TRAINING`. The default value for `UpdateEngine` method is to keep the
	// state the same as before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The engine training is paused.
	//   "TRAINING" - The engine is training.
	TrainingState string `json:"trainingState,omitempty"`
	// Type: Required. The type of engine. e.g., `recommended-for-you`. This field
	// together with optimization_objective describe engine metadata to use to
	// control engine training and serving. Currently supported values:
	// `recommended-for-you`, `others-you-may-like`, `more-like-this`,
	// `most-popular-items`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OptimizationObjective") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptimizationObjective") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimiz
// ationObjectiveConfig: Custom threshold for `cvr` optimization_objective.
type GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig struct {
	// TargetField: Required. The name of the field to target. Currently supported
	// values: `watch-percentage`, `watch-time`.
	TargetField string `json:"targetField,omitempty"`
	// TargetFieldValueFloat: Required. The threshold to be applied to the target
	// (e.g., 0.5).
	TargetFieldValueFloat float64 `json:"targetFieldValueFloat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	var s1 struct {
		TargetFieldValueFloat gensupport.JSONFloat64 `json:"targetFieldValueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetFieldValueFloat = float64(s1.TargetFieldValueFloat)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata: Additional
// information of a recommendation engine.
type GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata struct {
	// DataState: Output only. The state of data requirements for this engine:
	// `DATA_OK` and `DATA_ERROR`. Engine cannot be trained if the data is in
	// `DATA_ERROR` state. Engine can have `DATA_ERROR` state even if serving state
	// is `ACTIVE`: engines were trained successfully before, but cannot be
	// refreshed because the underlying engine no longer has sufficient data for
	// training.
	//
	// Possible values:
	//   "DATA_STATE_UNSPECIFIED" - Unspecified default value, should never be
	// explicitly set.
	//   "DATA_OK" - The engine has sufficient training data.
	//   "DATA_ERROR" - The engine does not have sufficient training data. Error
	// messages can be queried via Stackdriver.
	DataState string `json:"dataState,omitempty"`
	// LastTuneTime: Output only. The timestamp when the latest successful tune
	// finished. Only applicable on Media Recommendation engines.
	LastTuneTime string `json:"lastTuneTime,omitempty"`
	// ServingState: Output only. The serving state of the engine: `ACTIVE`,
	// `NOT_ACTIVE`.
	//
	// Possible values:
	//   "SERVING_STATE_UNSPECIFIED" - Unspecified serving state.
	//   "INACTIVE" - The engine is not serving.
	//   "ACTIVE" - The engine is serving and can be queried.
	//   "TUNED" - The engine is trained on tuned hyperparameters and can be
	// queried.
	ServingState string `json:"servingState,omitempty"`
	// TuningOperation: Output only. The latest tune operation id associated with
	// the engine. Only applicable on Media Recommendation engines. If present,
	// this operation id can be used to determine if there is an ongoing tune for
	// this engine. To check the operation status, send the GetOperation request
	// with this operation id in the engine resource format. If no tuning has
	// happened for this engine, the string is empty.
	TuningOperation string `json:"tuningOperation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig: Configurations
// for a Search Engine.
type GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig:
// Additional config specs for a `similar-items` engine.
type GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata: Metadata related
// to the progress of the EstimateDataSize operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse: Response of the
// EstimateDataSize request. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse struct {
	// DataSizeBytes: Data size in terms of bytes.
	DataSizeBytes int64 `json:"dataSizeBytes,omitempty,string"`
	// DocumentCount: Total number of documents.
	DocumentCount int64 `json:"documentCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DataSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSizeBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaFieldConfig: Configurations for fields of a
// schema. For example, configuring a field is indexable, or searchable.
type GoogleCloudDiscoveryengineV1alphaFieldConfig struct {
	// AdvancedSiteSearchDataSources: If this field is set, only the corresponding
	// source will be indexed for this field. Otherwise, the values from different
	// sources are merged. Assuming a page with `` in meta tag, and `` in page map:
	// if this enum is set to METATAGS, we will only index ``; if this enum is not
	// set, we will merge them and index ``.
	//
	// Possible values:
	//   "ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED" - Value used when unset.
	//   "METATAGS" - Retrieve value from meta tag.
	//   "PAGEMAP" - Retrieve value from page map.
	//   "SCHEMA_ORG" - Retrieve value from schema.org data.
	AdvancedSiteSearchDataSources []string `json:"advancedSiteSearchDataSources,omitempty"`
	// CompletableOption: If completable_option is COMPLETABLE_ENABLED, field
	// values are directly used and returned as suggestions for Autocomplete in
	// CompletionService.CompleteQuery. If completable_option is unset, the server
	// behavior defaults to COMPLETABLE_DISABLED for fields that support setting
	// completable options, which are just `string` fields. For those fields that
	// do not support setting completable options, the server will skip completable
	// option setting, and setting completable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "COMPLETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "COMPLETABLE_ENABLED" - Completable option enabled for a schema field.
	//   "COMPLETABLE_DISABLED" - Completable option disabled for a schema field.
	CompletableOption string `json:"completableOption,omitempty"`
	// DynamicFacetableOption: If dynamic_facetable_option is
	// DYNAMIC_FACETABLE_ENABLED, field values are available for dynamic facet.
	// Could only be DYNAMIC_FACETABLE_DISABLED if FieldConfig.indexable_option is
	// INDEXABLE_DISABLED. Otherwise, an `INVALID_ARGUMENT` error will be returned.
	// If dynamic_facetable_option is unset, the server behavior defaults to
	// DYNAMIC_FACETABLE_DISABLED for fields that support setting dynamic facetable
	// options. For those fields that do not support setting dynamic facetable
	// options, such as `object` and `boolean`, the server will skip dynamic
	// facetable option setting, and setting dynamic_facetable_option for those
	// fields will throw `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "DYNAMIC_FACETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "DYNAMIC_FACETABLE_ENABLED" - Dynamic facetable option enabled for a
	// schema field.
	//   "DYNAMIC_FACETABLE_DISABLED" - Dynamic facetable option disabled for a
	// schema field.
	DynamicFacetableOption string `json:"dynamicFacetableOption,omitempty"`
	// FieldPath: Required. Field path of the schema field. For example: `title`,
	// `description`, `release_info.release_year`.
	FieldPath string `json:"fieldPath,omitempty"`
	// FieldType: Output only. Raw type of the field.
	//
	// Possible values:
	//   "FIELD_TYPE_UNSPECIFIED" - Field type is unspecified.
	//   "OBJECT" - Field value type is Object.
	//   "STRING" - Field value type is String.
	//   "NUMBER" - Field value type is Number.
	//   "INTEGER" - Field value type is Integer.
	//   "BOOLEAN" - Field value type is Boolean.
	//   "GEOLOCATION" - Field value type is Geolocation. Geolocation is expressed
	// as an object with the following keys: * `id`: a string representing the
	// location id * `longitude`: a number representing the longitude coordinate of
	// the location * `latitude`: a number repesenting the latitude coordinate of
	// the location * `address`: a string representing the full address of the
	// location `latitude` and `longitude` must always be provided together. At
	// least one of a) `address` or b) `latitude`-`longitude` pair must be
	// provided.
	//   "DATETIME" - Field value type is Datetime. Datetime can be expressed as
	// either: * a number representing milliseconds-since-the-epoch * a string
	// representing milliseconds-since-the-epoch. e.g. "1420070400001" * a string
	// representing the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date or
	// date and time. e.g. "2015-01-01" or "2015-01-01T12:10:30Z"
	FieldType string `json:"fieldType,omitempty"`
	// IndexableOption: If indexable_option is INDEXABLE_ENABLED, field values are
	// indexed so that it can be filtered or faceted in SearchService.Search. If
	// indexable_option is unset, the server behavior defaults to
	// INDEXABLE_DISABLED for fields that support setting indexable options. For
	// those fields that do not support setting indexable options, such as `object`
	// and `boolean` and key properties, the server will skip indexable_option
	// setting, and setting indexable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "INDEXABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "INDEXABLE_ENABLED" - Indexable option enabled for a schema field.
	//   "INDEXABLE_DISABLED" - Indexable option disabled for a schema field.
	IndexableOption string `json:"indexableOption,omitempty"`
	// KeyPropertyType: Output only. Type of the key property that this field is
	// mapped to. Empty string if this is not annotated as mapped to a key
	// property. Example types are `title`, `description`. Full list is defined by
	// `keyPropertyMapping` in the schema field annotation. If the schema field has
	// a `KeyPropertyMapping` annotation, `indexable_option` and
	// `searchable_option` of this field cannot be modified.
	KeyPropertyType string `json:"keyPropertyType,omitempty"`
	// RecsFilterableOption: If recs_filterable_option is FILTERABLE_ENABLED, field
	// values are filterable by filter expression in
	// RecommendationService.Recommend. If FILTERABLE_ENABLED but the field type is
	// numerical, field values are not filterable by text queries in
	// RecommendationService.Recommend. Only textual fields are supported. If
	// recs_filterable_option is unset, the default setting is FILTERABLE_DISABLED
	// for fields that support setting filterable options. When a field set to
	// [FILTERABLE_DISABLED] is filtered, a warning is generated and an empty
	// result is returned.
	//
	// Possible values:
	//   "FILTERABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "FILTERABLE_ENABLED" - Filterable option enabled for a schema field.
	//   "FILTERABLE_DISABLED" - Filterable option disabled for a schema field.
	RecsFilterableOption string `json:"recsFilterableOption,omitempty"`
	// RetrievableOption: If retrievable_option is RETRIEVABLE_ENABLED, field
	// values are included in the search results. If retrievable_option is unset,
	// the server behavior defaults to RETRIEVABLE_DISABLED for fields that support
	// setting retrievable options. For those fields that do not support setting
	// retrievable options, such as `object` and `boolean`, the server will skip
	// retrievable option setting, and setting retrievable_option for those fields
	// will throw `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "RETRIEVABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "RETRIEVABLE_ENABLED" - Retrievable option enabled for a schema field.
	//   "RETRIEVABLE_DISABLED" - Retrievable option disabled for a schema field.
	RetrievableOption string `json:"retrievableOption,omitempty"`
	// SchemaOrgPaths: Field paths for indexing custom attribute from schema.org
	// data. More details of schema.org and its defined types can be found at
	// schema.org (https://schema.org). It is only used on advanced site search
	// schema. Currently only support full path from root. The full path to a field
	// is constructed by concatenating field names, starting from `_root`, with a
	// period `.` as the delimiter. Examples: * Publish date of the root:
	// _root.datePublished * Publish date of the reviews:
	// _root.review.datePublished
	SchemaOrgPaths []string `json:"schemaOrgPaths,omitempty"`
	// SearchableOption: If searchable_option is SEARCHABLE_ENABLED, field values
	// are searchable by text queries in SearchService.Search. If
	// SEARCHABLE_ENABLED but field type is numerical, field values will not be
	// searchable by text queries in SearchService.Search, as there are no text
	// values associated to numerical fields. If searchable_option is unset, the
	// server behavior defaults to SEARCHABLE_DISABLED for fields that support
	// setting searchable options. Only `string` fields that have no key property
	// mapping support setting searchable_option. For those fields that do not
	// support setting searchable options, the server will skip searchable option
	// setting, and setting searchable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "SEARCHABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "SEARCHABLE_ENABLED" - Searchable option enabled for a schema field.
	//   "SEARCHABLE_DISABLED" - Searchable option disabled for a schema field.
	SearchableOption string `json:"searchableOption,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AdvancedSiteSearchDataSources") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSiteSearchDataSources")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaFieldConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaFieldConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaIdpConfig: Identity Provider Config.
type GoogleCloudDiscoveryengineV1alphaIdpConfig struct {
	// ExternalIdpConfig: External Identity provider config.
	ExternalIdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig `json:"externalIdpConfig,omitempty"`
	// IdpType: Identity provider type configured.
	//
	// Possible values:
	//   "IDP_TYPE_UNSPECIFIED" - Default value. ACL search not enabled.
	//   "GSUITE" - Google 1P provider.
	//   "THIRD_PARTY" - Third party provider.
	IdpType string `json:"idpType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalIdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalIdpConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaIdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaIdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig: Third party IDP
// Config.
type GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig struct {
	// WorkforcePoolName: Workforce pool name. Example:
	// "locations/global/workforcePools/pool_id"
	WorkforcePoolName string `json:"workforcePoolName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WorkforcePoolName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkforcePoolName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata:
// Metadata related to the progress of the ImportCompletionSuggestions
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse:
// Response of the CompletionService.ImportCompletionSuggestions method. If the
// long running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata: Metadata related
// to the progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1alphaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata: Metadata related
// to the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaLanguageInfo: Language info for DataStore.
type GoogleCloudDiscoveryengineV1alphaLanguageInfo struct {
	// Language: Output only. Language part of normalized_language_code. E.g.:
	// `en-US` -> `en`, `zh-Hans-HK` -> `zh`, `en` -> `en`.
	Language string `json:"language,omitempty"`
	// LanguageCode: The language code for the DataStore.
	LanguageCode string `json:"languageCode,omitempty"`
	// NormalizedLanguageCode: Output only. This is the normalized form of
	// language_code. E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb`
	// will have normalized_language_code of `en-GB`.
	NormalizedLanguageCode string `json:"normalizedLanguageCode,omitempty"`
	// Region: Output only. Region part of normalized_language_code, if present.
	// E.g.: `en-US` -> `US`, `zh-Hans-HK` -> `HK`, `en` -> ``.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Language") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Language") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaLanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaLanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListCustomModelsResponse: Response message
// for SearchTuningService.ListCustomModels method.
type GoogleCloudDiscoveryengineV1alphaListCustomModelsResponse struct {
	// Models: List of custom tuning models.
	Models []*GoogleCloudDiscoveryengineV1alphaCustomTuningModel `json:"models,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaListCustomModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListCustomModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaProject: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1alphaProject struct {
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project_number}`. Note that when making requests, project number
	// and project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1alphaProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaProject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaProject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaProjectServiceTerms: Metadata about the
// terms of service.
type GoogleCloudDiscoveryengineV1alphaProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaProvisionProjectMetadata: Metadata
// associated with a project provision operation.
type GoogleCloudDiscoveryengineV1alphaProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata:
// Metadata related to the progress of the PurgeCompletionSuggestions
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse:
// Response message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeSucceeded: Whether the completion suggestions were successfully purged.
	PurgeSucceeded bool `json:"purgeSucceeded,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata: Metadata related to
// the progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse: Response message
// for DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the PurgeSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse:
// Response message for CompletionService.PurgeSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata: Metadata related
// to the progress of the PurgeUserEvents operation. This will be returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse struct {
	// PurgeCount: The total count of events purged as a result of the operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaQuery: Defines a user inputed query.
type GoogleCloudDiscoveryengineV1alphaQuery struct {
	// QueryId: Unique Id for the query.
	QueryId string `json:"queryId,omitempty"`
	// Text: Plain text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata: Metadata related to
// the progress of the SiteSearchEngineService.RecrawlUris operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// InvalidUris: Unique URIs in the request that don't match any TargetSite in
	// the DataStore, only match TargetSites that haven't been fully indexed, or
	// match a TargetSite with type EXCLUDE.
	InvalidUris []string `json:"invalidUris,omitempty"`
	// PendingCount: Total number of URIs that have yet to be crawled.
	PendingCount int64 `json:"pendingCount,omitempty"`
	// QuotaExceededCount: Total number of URIs that were rejected due to
	// insufficient indexing resources.
	QuotaExceededCount int64 `json:"quotaExceededCount,omitempty"`
	// SuccessCount: Total number of URIs that have been crawled so far.
	SuccessCount int64 `json:"successCount,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValidUrisCount: Total number of unique URIs in the request that are not in
	// invalid_uris.
	ValidUrisCount int64 `json:"validUrisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse: Response message for
// SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse struct {
	// FailedUris: URIs that were not crawled before the LRO terminated.
	FailedUris []string `json:"failedUris,omitempty"`
	// FailureSamples: Details for a sample of up to 10 `failed_uris`.
	FailureSamples []*GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo `json:"failureSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo: Details
// about why a particular URI failed to be crawled. Each FailureInfo contains
// one FailureReason per CorpusType.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo struct {
	// FailureReasons: List of failure reasons by corpus type (e.g. desktop,
	// mobile).
	FailureReasons []*GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason `json:"failureReasons,omitempty"`
	// Uri: URI that failed to be crawled.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureReasons") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason:
//
//	Details about why crawling failed for a particular CorpusType, e.g.,
//
// DESKTOP and MOBILE crawling may fail for different reasons.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason struct {
	// CorpusType: DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
	//
	// Possible values:
	//   "CORPUS_TYPE_UNSPECIFIED" - Default value.
	//   "DESKTOP" - Denotes a crawling attempt for the desktop version of a page.
	//   "MOBILE" - Denotes a crawling attempt for the mobile version of a page.
	CorpusType string `json:"corpusType,omitempty"`
	// ErrorMessage: Reason why the URI was not crawled.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorpusType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorpusType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSchema: Defines the structure and layout of
// a type of document data.
type GoogleCloudDiscoveryengineV1alphaSchema struct {
	// FieldConfigs: Output only. Configurations for fields of the schema.
	FieldConfigs []*GoogleCloudDiscoveryengineV1alphaFieldConfig `json:"fieldConfigs,omitempty"`
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSession: External session proto definition.
type GoogleCloudDiscoveryengineV1alphaSession struct {
	// EndTime: Output only. The time the session finished.
	EndTime string `json:"endTime,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*`
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the session started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the session.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is unspecified.
	//   "IN_PROGRESS" - The session is currently open.
	State string `json:"state,omitempty"`
	// Turns: Turns.
	Turns []*GoogleCloudDiscoveryengineV1alphaSessionTurn `json:"turns,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSession) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSession
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSessionTurn: Represents a turn, including a
// query from the user and a answer from service.
type GoogleCloudDiscoveryengineV1alphaSessionTurn struct {
	// Answer: The resource name of the answer to the user query. Only set if the
	// answer generation (/answer API call) happened in this turn.
	Answer string `json:"answer,omitempty"`
	// Query: The user query.
	Query *GoogleCloudDiscoveryengineV1alphaQuery `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSessionTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSessionTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo: Verification
// information for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the ownership and
	// validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification failed.
	//   "EXEMPTED" - Site exempt from verification, e.g., a public website that
	// opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`
	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteVerificationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1alphaTargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated to
	// include all pages whose address contains the provided_uri_pattern. If set to
	// true, an uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to generate the
	// URI pattern to be used by the search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`
	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason `json:"failureReason,omitempty"`
	// GeneratedUriPattern: Output only. This is system-generated based on the
	// provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`
	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be picked up
	// by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to be
	// deleted. This is a transitioning state which will resulted in either: 1.
	// target site deleted if unindexing is successful; 2. state reverts to
	// SUCCEEDED if the unindexing fails.
	IndexingStatus string `json:"indexingStatus,omitempty"`
	// Name: Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`
	// ProvidedUriPattern: Required. Input only. The user provided URI pattern from
	// which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`
	// RootDomainUri: Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `json:"rootDomainUri,omitempty"`
	// SiteVerificationInfo: Output only. Site ownership and validity verification
	// status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo `json:"siteVerificationInfo,omitempty"`
	// Type: The type of the target site, e.g., whether the site is to be included
	// or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server behavior
	// defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason: Site search
// indexing failure reasons.
type GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuotaFailure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure: Failed
// due to insufficient quota.
type GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure struct {
	// TotalRequiredQuota: This number is an estimation on how much total quota
	// this project needs to successfully complete indexing.
	TotalRequiredQuota int64 `json:"totalRequiredQuota,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalRequiredQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalRequiredQuota") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata: Metadata related
// to the progress of the TrainCustomModel operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse: Response of the
// TrainCustomModelRequest. This message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the data.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelName: Fully qualified name of the CustomTuningModel.
	ModelName string `json:"modelName,omitempty"`
	// ModelStatus: The trained model status. Possible values are: * **bad-data**:
	// The training data quality is bad. * **no-improvement**: Tuning didn't
	// improve performance. Won't deploy. * **in-progress**: Model training job
	// creation is in progress. * **training**: Model is actively training. *
	// **evaluating**: The model is evaluating trained metrics. * **indexing**: The
	// model trained metrics are indexing. * **ready**: The model is ready for
	// serving.
	ModelStatus string `json:"modelStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata: Metadata associated
// with a tune operation.
type GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata struct {
	// Engine: Required. The resource name of the engine that this tune applies to.
	// Format:
	// `projects/{project_number}/locations/{location_id}/collections/{collection_id
	// }/engines/{engine_id}`
	Engine string `json:"engine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineResponse: Response associated
// with a tune operation.
type GoogleCloudDiscoveryengineV1alphaTuneEngineResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata: Metadata for
// UpdateSchema LRO.
type GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.UpdateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.BatchCreateTargetSites operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse: Response
// message for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1betaTargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCondition: Defines circumstances to be
// checked before allowing a behavior
type GoogleCloudDiscoveryengineV1betaCondition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1betaConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Maximum of 10
	// query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1betaConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConditionQueryTerm: Matcher for search
// request query
type GoogleCloudDiscoveryengineV1betaConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1betaConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControl: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1betaControl struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig ids this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1betaControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1betaCondition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1betaControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1betaControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1betaControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControl) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlBoostAction: Adjusts order of
// products in returned list.
type GoogleCloudDiscoveryengineV1betaControlBoostAction struct {
	// Boost: Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1betaControlFilterAction: Specified which
// products may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1betaControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlRedirectAction: Redirects a shopper
// to the provided URI.
type GoogleCloudDiscoveryengineV1betaControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlSynonymsAction: Creates a set of
// terms that will act as synonyms of one another. Example: "happy" will also
// be considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1betaControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata: Metadata related to
// the progress of the DataStoreService.CreateDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateEngineMetadata: Metadata related to
// the progress of the EngineService.CreateEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata: Metadata for Create
// Schema LRO.
type GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.CreateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCustomTuningModel: Metadata that describes a
// custom tuned model.
type GoogleCloudDiscoveryengineV1betaCustomTuningModel struct {
	// CreateTime: Timestamp the Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The display name of the model.
	DisplayName string `json:"displayName,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelState: The state that the model is in (e.g.`TRAINING` or
	// `TRAINING_FAILED`).
	//
	// Possible values:
	//   "MODEL_STATE_UNSPECIFIED" - Default value.
	//   "TRAINING_PAUSED" - The model is in a paused training state.
	//   "TRAINING" - The model is currently training.
	//   "TRAINING_COMPLETE" - The model has successfully completed training.
	//   "READY_FOR_SERVING" - The model is ready for serving.
	//   "TRAINING_FAILED" - The model training failed.
	//   "NO_IMPROVEMENT" - The model training finished successfully but metrics
	// did not improve.
	ModelState string `json:"modelState,omitempty"`
	// ModelVersion: The version of the model.
	ModelVersion int64 `json:"modelVersion,omitempty,string"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/customTuningModels/{custom_tuning_model}` model must be
	// an alpha-numerical string with limit of 40 characters.
	Name string `json:"name,omitempty"`
	// TrainingStartTime: Timestamp the model training was initiated.
	TrainingStartTime string `json:"trainingStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCustomTuningModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCustomTuningModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDataStore: DataStore captures global
// settings and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1betaDataStore struct {
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema asscociated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// LanguageInfo: Language info for DataStore.
	LanguageInfo *GoogleCloudDiscoveryengineV1betaLanguageInfo `json:"languageInfo,omitempty"`
	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1betaSchema `json:"startingSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata: Metadata related to
// the progress of the DataStoreService.DeleteDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata: Metadata related to
// the progress of the EngineService.DeleteEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.DeleteTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig: A singleton
// resource of DataStore. It's empty when DataStore is created, which defaults
// to digital parser. The first call to
// DataStoreService.UpdateDocumentProcessingConfig method will initialize the
// config.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutB
// asedChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig:
// Related configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalP
// arsingConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutPa
// rsingConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsi
// ngConfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1betaEngine: Metadata that describes the training
// and serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1betaEngine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1betaEngineCommonConfig `json:"commonConfig,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// IndustryVertical: The industry vertical that the engine registers. The
	// restriction of the Engine industry vertical is based on DataStore: If
	// unspecified, default to `GENERIC`. Vertical on Engine has to match vertical
	// of the DataStore linked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// Name: Immutable. The fully qualified resource name of the engine. This field
	// must be a UTF-8 encoded string with a length limit of 1024 characters.
	// Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/engi
	// nes/{engine}` engine should be 1-63 characters, and valid characters are
	// /a-z0-9*/. Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatEngineConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig: Configurations for a
// Chat Engine.
type GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata: Additional
// information of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineCommonConfig: Common configurations
// for an Engine.
type GoogleCloudDiscoveryengineV1betaEngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig: Configurations for
// a Search Engine.
type GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata:
// Metadata related to the progress of the ImportCompletionSuggestions
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse:
// Response of the CompletionService.ImportCompletionSuggestions method. If the
// long running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata: Metadata related to
// the progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1betaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1betaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata: Metadata related
// to the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1betaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaLanguageInfo: Language info for DataStore.
type GoogleCloudDiscoveryengineV1betaLanguageInfo struct {
	// Language: Output only. Language part of normalized_language_code. E.g.:
	// `en-US` -> `en`, `zh-Hans-HK` -> `zh`, `en` -> `en`.
	Language string `json:"language,omitempty"`
	// LanguageCode: The language code for the DataStore.
	LanguageCode string `json:"languageCode,omitempty"`
	// NormalizedLanguageCode: Output only. This is the normalized form of
	// language_code. E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb`
	// will have normalized_language_code of `en-GB`.
	NormalizedLanguageCode string `json:"normalizedLanguageCode,omitempty"`
	// Region: Output only. Region part of normalized_language_code, if present.
	// E.g.: `en-US` -> `US`, `zh-Hans-HK` -> `HK`, `en` -> ``.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Language") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Language") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaLanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaLanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListCustomModelsResponse: Response message
// for SearchTuningService.ListCustomModels method.
type GoogleCloudDiscoveryengineV1betaListCustomModelsResponse struct {
	// Models: List of custom tuning models.
	Models []*GoogleCloudDiscoveryengineV1betaCustomTuningModel `json:"models,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListCustomModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListCustomModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaProject: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1betaProject struct {
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project_number}`. Note that when making requests, project number
	// and project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1betaProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaProject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaProject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaProjectServiceTerms: Metadata about the
// terms of service.
type GoogleCloudDiscoveryengineV1betaProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaProvisionProjectMetadata: Metadata
// associated with a project provision operation.
type GoogleCloudDiscoveryengineV1betaProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata: Metadata related to
// the progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse: Response message for
// DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the PurgeSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse:
// Response message for CompletionService.PurgeSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSchema: Defines the structure and layout of
// a type of document data.
type GoogleCloudDiscoveryengineV1betaSchema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JsonSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSiteVerificationInfo: Verification
// information for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1betaSiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the ownership and
	// validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification failed.
	//   "EXEMPTED" - Site exempt from verification, e.g., a public website that
	// opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`
	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteVerificationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSiteVerificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1betaTargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated to
	// include all pages whose address contains the provided_uri_pattern. If set to
	// true, an uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to generate the
	// URI pattern to be used by the search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`
	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason `json:"failureReason,omitempty"`
	// GeneratedUriPattern: Output only. This is system-generated based on the
	// provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`
	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be picked up
	// by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to be
	// deleted. This is a transitioning state which will resulted in either: 1.
	// target site deleted if unindexing is successful; 2. state reverts to
	// SUCCEEDED if the unindexing fails.
	IndexingStatus string `json:"indexingStatus,omitempty"`
	// Name: Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`
	// ProvidedUriPattern: Required. Input only. The user provided URI pattern from
	// which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`
	// RootDomainUri: Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `json:"rootDomainUri,omitempty"`
	// SiteVerificationInfo: Output only. Site ownership and validity verification
	// status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1betaSiteVerificationInfo `json:"siteVerificationInfo,omitempty"`
	// Type: The type of the target site, e.g., whether the site is to be included
	// or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server behavior
	// defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaTargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTargetSite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason: Site search
// indexing failure reasons.
type GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuotaFailure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure: Failed
// due to insufficient quota.
type GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure struct {
	// TotalRequiredQuota: This number is an estimation on how much total quota
	// this project needs to successfully complete indexing.
	TotalRequiredQuota int64 `json:"totalRequiredQuota,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalRequiredQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalRequiredQuota") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTrainCustomModelMetadata: Metadata related
// to the progress of the TrainCustomModel operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaTrainCustomModelMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaTrainCustomModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTrainCustomModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTrainCustomModelResponse: Response of the
// TrainCustomModelRequest. This message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1betaTrainCustomModelResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the data.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelName: Fully qualified name of the CustomTuningModel.
	ModelName string `json:"modelName,omitempty"`
	// ModelStatus: The trained model status. Possible values are: * **bad-data**:
	// The training data quality is bad. * **no-improvement**: Tuning didn't
	// improve performance. Won't deploy. * **in-progress**: Model training job
	// creation is in progress. * **training**: Model is actively training. *
	// **evaluating**: The model is evaluating trained metrics. * **indexing**: The
	// model trained metrics are indexing. * **ready**: The model is ready for
	// serving.
	ModelStatus string `json:"modelStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaTrainCustomModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTrainCustomModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTuneEngineMetadata: Metadata associated with
// a tune operation.
type GoogleCloudDiscoveryengineV1betaTuneEngineMetadata struct {
	// Engine: Required. The resource name of the engine that this tune applies to.
	// Format:
	// `projects/{project_number}/locations/{location_id}/collections/{collection_id
	// }/engines/{engine_id}`
	Engine string `json:"engine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaTuneEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTuneEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTuneEngineResponse: Response associated with
// a tune operation.
type GoogleCloudDiscoveryengineV1betaTuneEngineResponse struct {
}

// GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata: Metadata for
// UpdateSchema LRO.
type GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaUpdateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.UpdateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaUpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaUpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaUpdateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningCancelOperationRequest: The request message for
// Operations.CancelOperation.
type GoogleLongrunningCancelOperationRequest struct {
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsProvisionCall struct {
	s                                                   *Service
	name                                                string
	googleclouddiscoveryenginev1provisionprojectrequest *GoogleCloudDiscoveryengineV1ProvisionProjectRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Provision: Provisions the project resource. During the process, related
// systems will get prepared and initialized. Caller must read the Terms for
// data use (https://cloud.google.com/retail/data-use-terms), and optionally
// specify in request to provide consent to that service terms.
//
//   - name: Full resource name of a Project, such as
//     `projects/{project_id_or_number}`.
func (r *ProjectsService) Provision(name string, googleclouddiscoveryenginev1provisionprojectrequest *GoogleCloudDiscoveryengineV1ProvisionProjectRequest) *ProjectsProvisionCall {
	c := &ProjectsProvisionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1provisionprojectrequest = googleclouddiscoveryenginev1provisionprojectrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsProvisionCall) Fields(s ...googleapi.Field) *ProjectsProvisionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsProvisionCall) Context(ctx context.Context) *ProjectsProvisionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsProvisionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsProvisionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1provisionprojectrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:provision")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.provision" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsProvisionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataConnectorOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataConnectorOperationsService) Get(name string) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataConnectorOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataConnector.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataConnectorOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataConnectorOperationsService) List(name string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c := &ProjectsLocationsCollectionsDataConnectorOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataConnector.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresCompleteQueryCall struct {
	s            *Service
	dataStore    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CompleteQuery: Completes the specified user input with keyword suggestions.
//
//   - dataStore: The parent data store resource name for which the completion is
//     performed, such as
//     `projects/*/locations/global/collections/default_collection/dataStores/defa
//     ult_data_store`.
func (r *ProjectsLocationsCollectionsDataStoresService) CompleteQuery(dataStore string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c := &ProjectsLocationsCollectionsDataStoresCompleteQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataStore = dataStore
	return c
}

// IncludeTailSuggestions sets the optional parameter "includeTailSuggestions":
// Indicates if tail suggestions should be returned if there are no suggestions
// that match the full query. Even if set to true, if there are suggestions
// that match the full query, those are returned and no tail suggestions are
// returned.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) IncludeTailSuggestions(includeTailSuggestions bool) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("includeTailSuggestions", fmt.Sprint(includeTailSuggestions))
	return c
}

// Query sets the optional parameter "query": Required. The typeahead input
// used to fetch suggestions. Maximum length is 128 characters.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Query(query string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("query", query)
	return c
}

// QueryModel sets the optional parameter "queryModel": Specifies the
// autocomplete data model. This overrides any model specified in the
// Configuration > Autocomplete section of the Cloud console. Currently
// supported values: * `document` - Using suggestions generated from
// user-imported documents. * `search-history` - Using suggestions generated
// from the past history of SearchService.Search API calls. Do not use it when
// there is no traffic for Search API. * `user-event` - Using suggestions
// generated from user-imported search events. * `document-completable` - Using
// suggestions taken directly from user-imported document fields marked as
// completable. Default values: * `document` is the default model for regular
// dataStores. * `search-history` is the default model for site search
// dataStores.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) QueryModel(queryModel string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("queryModel", queryModel)
	return c
}

// UserPseudoId sets the optional parameter "userPseudoId": A unique identifier
// for tracking visitors. For example, this could be implemented with an HTTP
// cookie, which should be able to uniquely identify a visitor on a single
// device. This unique identifier should not change if the visitor logs in or
// out of the website. This field should NOT have a fixed value such as
// `unknown_visitor`. This should be the same identifier as
// UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The field must be
// a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
// `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) UserPseudoId(userPseudoId string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("userPseudoId", userPseudoId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+dataStore}:completeQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataStore": c.dataStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.completeQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1CompleteQueryResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1CompleteQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1CompleteQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresCreateCall struct {
	s                                     *Service
	parent                                string
	googleclouddiscoveryenginev1datastore *GoogleCloudDiscoveryengineV1DataStore
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates a DataStore. DataStore is for storing Documents. To serve
// these documents for Search, or Recommendation use case, an Engine needs to
// be created separately.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}`.
func (r *ProjectsLocationsCollectionsDataStoresService) Create(parent string, googleclouddiscoveryenginev1datastore *GoogleCloudDiscoveryengineV1DataStore) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1datastore = googleclouddiscoveryenginev1datastore
	return c
}

// CreateAdvancedSiteSearch sets the optional parameter
// "createAdvancedSiteSearch": A boolean flag indicating whether user want to
// directly create an advanced data store for site search. If the data store is
// not configured as site search (GENERIC vertical and PUBLIC_WEBSITE
// content_config), this flag will be ignored.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) CreateAdvancedSiteSearch(createAdvancedSiteSearch bool) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.urlParams_.Set("createAdvancedSiteSearch", fmt.Sprint(createAdvancedSiteSearch))
	return c
}

// DataStoreId sets the optional parameter "dataStoreId": Required. The ID to
// use for the DataStore, which will become the final component of the
// DataStore's resource name. This field must conform to RFC-1034
// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
// characters. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) DataStoreId(dataStoreId string) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.urlParams_.Set("dataStoreId", dataStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1datastore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataStore.
//
//   - name: Full resource name of DataStore, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}/dataSt
//     ores/{data_store_id}`. If the caller does not have permission to delete
//     the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED
//     error is returned. If the DataStore to delete does not exist, a NOT_FOUND
//     error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) Delete(name string) *ProjectsLocationsCollectionsDataStoresDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DataStore.
//
//   - name: Full resource name of DataStore, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}/dataSt
//     ores/{data_store_id}`. If the caller does not have permission to access
//     the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED
//     error is returned. If the requested DataStore does not exist, a NOT_FOUND
//     error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) Get(name string) *ProjectsLocationsCollectionsDataStoresGetCall {
	c := &ProjectsLocationsCollectionsDataStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1DataStore.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1DataStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1DataStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSiteSearchEngine: Gets the SiteSearchEngine.
//
//   - name: Resource name of SiteSearchEngine, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/siteSearchEngine`. If the caller does not have permission
//     to access the [SiteSearchEngine], regardless of whether or not it exists,
//     a PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) GetSiteSearchEngine(name string) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c := &ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.getSiteSearchEngine" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1SiteSearchEngine.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1SiteSearchEngine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1SiteSearchEngine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the DataStores associated with the project.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}`. If
//     the caller does not have permission to list DataStores under this
//     location, regardless of whether or not this data store exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) List(parent string) *ProjectsLocationsCollectionsDataStoresListCall {
	c := &ProjectsLocationsCollectionsDataStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter by solution type . For
// example: `filter = 'solution_type:SOLUTION_TYPE_SEARCH'`
func (c *ProjectsLocationsCollectionsDataStoresListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// DataStores to return. If unspecified, defaults to 10. The maximum allowed
// value is 50. Values above 50 will be coerced to 50. If this field is
// negative, an INVALID_ARGUMENT is returned.
func (c *ProjectsLocationsCollectionsDataStoresListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListDataStoresResponse.next_page_token, received from a previous
// DataStoreService.ListDataStores call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// DataStoreService.ListDataStores must match the call that provided the page
// token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ListDataStoresResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ListDataStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ListDataStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1ListDataStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresPatchCall struct {
	s                                     *Service
	name                                  string
	googleclouddiscoveryenginev1datastore *GoogleCloudDiscoveryengineV1DataStore
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a DataStore
//
//   - name: Immutable. The full resource name of the data store. Format:
//     `projects/{project}/locations/{location}/collections/{collection_id}/dataSt
//     ores/{data_store_id}`. This field must be a UTF-8 encoded string with a
//     length limit of 1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresService) Patch(name string, googleclouddiscoveryenginev1datastore *GoogleCloudDiscoveryengineV1DataStore) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1datastore = googleclouddiscoveryenginev1datastore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided DataStore to update. If an unsupported or unknown field is
// provided, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1datastore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1DataStore.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1DataStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1DataStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall struct {
	s                                    *Service
	parent                               string
	googleclouddiscoveryenginev1document *GoogleCloudDiscoveryengineV1Document
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Create: Creates a Document.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Create(parent string, googleclouddiscoveryenginev1document *GoogleCloudDiscoveryengineV1Document) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1document = googleclouddiscoveryenginev1document
	return c
}

// DocumentId sets the optional parameter "documentId": Required. The ID to use
// for the Document, which becomes the final component of the Document.name. If
// the caller does not have permission to create the Document, regardless of
// whether or not it exists, a `PERMISSION_DENIED` error is returned. This
// field must be unique among all Documents with the same parent. Otherwise, an
// `ALREADY_EXISTS` error is returned. This field must conform to RFC-1034
// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) DocumentId(documentId string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("documentId", documentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1document)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}/documents/{document}`. If the caller does
//     not have permission to delete the Document, regardless of whether or not
//     it exists, a `PERMISSION_DENIED` error is returned. If the Document to
//     delete does not exist, a `NOT_FOUND` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}/documents/{document}`. If the caller does
//     not have permission to access the Document, regardless of whether or not
//     it exists, a `PERMISSION_DENIED` error is returned. If the requested
//     Document does not exist, a `NOT_FOUND` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Get(name string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall struct {
	s                                                  *Service
	parent                                             string
	googleclouddiscoveryenginev1importdocumentsrequest *GoogleCloudDiscoveryengineV1ImportDocumentsRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Import: Bulk import of multiple Documents. Request processing may be
// synchronous. Non-existing items are created. Note: It is possible for a
// subset of the Documents to be successfully updated.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}`. Requires create/update permission.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Import(parent string, googleclouddiscoveryenginev1importdocumentsrequest *GoogleCloudDiscoveryengineV1ImportDocumentsRequest) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1importdocumentsrequest = googleclouddiscoveryenginev1importdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1importdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Documents.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}`. Use `default_branch` as the branch ID,
//     to list documents under the default branch. If the caller does not have
//     permission to list Documents under this branch, regardless of whether or
//     not this branch exists, a `PERMISSION_DENIED` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) List(parent string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Documents
// to return. If unspecified, defaults to 100. The maximum allowed value is
// 1000. Values above 1000 are set to 1000. If this field is negative, an
// `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListDocumentsResponse.next_page_token, received from a previous
// DocumentService.ListDocuments call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to
// DocumentService.ListDocuments must match the call that provided the page
// token. Otherwise, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ListDocumentsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1ListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall struct {
	s                                    *Service
	name                                 string
	googleclouddiscoveryenginev1document *GoogleCloudDiscoveryengineV1Document
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Patch: Updates a Document.
//
//   - name: Immutable. The full resource name of the document. Format:
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}/documents/{document_id}`. This field must
//     be a UTF-8 encoded string with a length limit of 1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Patch(name string, googleclouddiscoveryenginev1document *GoogleCloudDiscoveryengineV1Document) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1document = googleclouddiscoveryenginev1document
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to `true`
// and the Document is not found, a new Document is be created.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided imported 'document' to update. If not set, by default
// updates all fields.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1document)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall struct {
	s                                                 *Service
	parent                                            string
	googleclouddiscoveryenginev1purgedocumentsrequest *GoogleCloudDiscoveryengineV1PurgeDocumentsRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Purge: Permanently deletes all selected Documents in a branch. This process
// is asynchronous. Depending on the number of Documents to be deleted, this
// operation can take hours to complete. Before the delete operation completes,
// some Documents might still be returned by DocumentService.GetDocument or
// DocumentService.ListDocuments. To get a list of the Documents to be deleted,
// set PurgeDocumentsRequest.force to false.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Purge(parent string, googleclouddiscoveryenginev1purgedocumentsrequest *GoogleCloudDiscoveryengineV1PurgeDocumentsRequest) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1purgedocumentsrequest = googleclouddiscoveryenginev1purgedocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1purgedocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall struct {
	s                                       *Service
	name                                    string
	googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) Cancel(name string, googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest) *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningcanceloperationrequest = googlelongrunningcanceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlelongrunningcanceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall struct {
	s                                                              *Service
	parent                                                         string
	googleclouddiscoveryenginev1importcompletionsuggestionsrequest *GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// Import: Imports CompletionSuggestions for a DataStore.
//
//   - parent: The parent data store resource name for which to import customer
//     autocomplete suggestions. Follows pattern
//     `projects/*/locations/*/collections/*/dataStores/*`.
func (r *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService) Import(parent string, googleclouddiscoveryenginev1importcompletionsuggestionsrequest *GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall {
	c := &ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1importcompletionsuggestionsrequest = googleclouddiscoveryenginev1importcompletionsuggestionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1importcompletionsuggestionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/completionSuggestions:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.completionSuggestions.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall struct {
	s                                                             *Service
	parent                                                        string
	googleclouddiscoveryenginev1purgecompletionsuggestionsrequest *GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// Purge: Permanently deletes all CompletionSuggestions for a DataStore.
//
//   - parent: The parent data store resource name for which to purge completion
//     suggestions. Follows pattern
//     projects/*/locations/*/collections/*/dataStores/*.
func (r *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService) Purge(parent string, googleclouddiscoveryenginev1purgecompletionsuggestionsrequest *GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall {
	c := &ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1purgecompletionsuggestionsrequest = googleclouddiscoveryenginev1purgecompletionsuggestionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1purgecompletionsuggestionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/completionSuggestions:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.completionSuggestions.purge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresControlsCreateCall struct {
	s                                   *Service
	parent                              string
	googleclouddiscoveryenginev1control *GoogleCloudDiscoveryengineV1Control
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates a Control. By default 1000 controls are allowed for a data
// store. A request can be submitted to adjust this limit. If the Control to
// create already exists, an ALREADY_EXISTS error is returned.
//
//   - parent: Full resource name of parent data store. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection_
//     id}/dataStores/{data_store_id}` or
//     `projects/{project_number}/locations/{location_id}/collections/{collection_
//     id}/engines/{engine_id}`.
func (r *ProjectsLocationsCollectionsDataStoresControlsService) Create(parent string, googleclouddiscoveryenginev1control *GoogleCloudDiscoveryengineV1Control) *ProjectsLocationsCollectionsDataStoresControlsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresControlsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1control = googleclouddiscoveryenginev1control
	return c
}

// ControlId sets the optional parameter "controlId": Required. The ID to use
// for the Control, which will become the final component of the Control's
// resource name. This value must be within 1-63 characters. Valid characters
// are /a-z-_/.
func (c *ProjectsLocationsCollectionsDataStoresControlsCreateCall) ControlId(controlId string) *ProjectsLocationsCollectionsDataStoresControlsCreateCall {
	c.urlParams_.Set("controlId", controlId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresControlsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresControlsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresControlsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresControlsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresControlsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresControlsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1control)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/controls")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.controls.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Control.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresControlsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Control, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Control{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresControlsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Control. If the Control to delete does not exist, a
// NOT_FOUND error is returned.
//
//   - name: The resource name of the Control to delete. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection_
//     id}/dataStores/{data_store_id}/controls/{control_id}`.
func (r *ProjectsLocationsCollectionsDataStoresControlsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresControlsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresControlsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresControlsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresControlsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresControlsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresControlsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresControlsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresControlsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.controls.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresControlsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresControlsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Control.
//
//   - name: The resource name of the Control to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection_
//     id}/dataStores/{data_store_id}/controls/{control_id}`.
func (r *ProjectsLocationsCollectionsDataStoresControlsService) Get(name string) *ProjectsLocationsCollectionsDataStoresControlsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresControlsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresControlsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresControlsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresControlsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresControlsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresControlsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresControlsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresControlsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresControlsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.controls.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Control.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresControlsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Control, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Control{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresControlsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Controls by their parent DataStore.
//
//   - parent: The data store resource name. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection_
//     id}/dataStores/{data_store_id}` or
//     `projects/{project_number}/locations/{location_id}/collections/{collection_
//     id}/engines/{engine_id}`.
func (r *ProjectsLocationsCollectionsDataStoresControlsService) List(parent string) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c := &ProjectsLocationsCollectionsDataStoresControlsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the list
// results. Supported features: * List all the products under the parent branch
// if filter is unset. Currently this field is unsupported.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. If unspecified, defaults to 50. Max allowed value is 1000.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListControls` call. Provide this to retrieve the subsequent
// page.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresControlsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/controls")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.controls.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ListControlsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ListControlsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ListControlsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresControlsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1ListControlsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresControlsPatchCall struct {
	s                                   *Service
	name                                string
	googleclouddiscoveryenginev1control *GoogleCloudDiscoveryengineV1Control
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a Control. Control action type cannot be changed. If the
// Control to update does not exist, a NOT_FOUND error is returned.
//
//   - name: Immutable. Fully qualified name
//     `projects/*/locations/global/dataStore/*/controls/*`.
func (r *ProjectsLocationsCollectionsDataStoresControlsService) Patch(name string, googleclouddiscoveryenginev1control *GoogleCloudDiscoveryengineV1Control) *ProjectsLocationsCollectionsDataStoresControlsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresControlsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1control = googleclouddiscoveryenginev1control
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided Control to update. The following are NOT supported: *
// Control.name * Control.solution_type If not set or empty, all supported
// fields are updated.
func (c *ProjectsLocationsCollectionsDataStoresControlsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresControlsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresControlsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresControlsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresControlsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresControlsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresControlsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresControlsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1control)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.controls.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Control.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresControlsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Control, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Control{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresConversationsConverseCall struct {
	s                                                       *Service
	name                                                    string
	googleclouddiscoveryenginev1converseconversationrequest *GoogleCloudDiscoveryengineV1ConverseConversationRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Converse: Converses a conversation.
//
//   - name: The resource name of the Conversation to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}/conversations/{conversation_id}`. Use
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}/conversations/-` to activate auto session
//     mode, which automatically creates a new conversation inside a
//     ConverseConversation session.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Converse(name string, googleclouddiscoveryenginev1converseconversationrequest *GoogleCloudDiscoveryengineV1ConverseConversationRequest) *ProjectsLocationsCollectionsDataStoresConversationsConverseCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsConverseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1converseconversationrequest = googleclouddiscoveryenginev1converseconversationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsConverseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsConverseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1converseconversationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:converse")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.converse" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ConverseConversationResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ConverseConversationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ConverseConversationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresConversationsCreateCall struct {
	s                                        *Service
	parent                                   string
	googleclouddiscoveryenginev1conversation *GoogleCloudDiscoveryengineV1Conversation
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates a Conversation. If the Conversation to create already
// exists, an ALREADY_EXISTS error is returned.
//
//   - parent: Full resource name of parent data store. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Create(parent string, googleclouddiscoveryenginev1conversation *GoogleCloudDiscoveryengineV1Conversation) *ProjectsLocationsCollectionsDataStoresConversationsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1conversation = googleclouddiscoveryenginev1conversation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1conversation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Conversation.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Conversation. If the Conversation to delete does not
// exist, a NOT_FOUND error is returned.
//
//   - name: The resource name of the Conversation to delete. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}/conversations/{conversation_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Conversation.
//
//   - name: The resource name of the Conversation to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}/conversations/{conversation_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Conversation.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Conversations by their parent DataStore.
//
//   - parent: The data store resource name. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) List(parent string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the list
// results. The supported features are: user_pseudo_id, state. Example:
// "user_pseudo_id = some_id"
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": A comma-separated list of
// fields to order by, sorted in ascending order. Use "desc" after a field name
// for descending. Supported fields: * `update_time` * `create_time` *
// `conversation_name` Example: "update_time desc" "create_time"
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) OrderBy(orderBy string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. If unspecified, defaults to 50. Max allowed value is 1000.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListConversations` call. Provide this to retrieve the
// subsequent page.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ListConversationsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1ListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresConversationsPatchCall struct {
	s                                        *Service
	name                                     string
	googleclouddiscoveryenginev1conversation *GoogleCloudDiscoveryengineV1Conversation
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates a Conversation. Conversation action type cannot be changed.
// If the Conversation to update does not exist, a NOT_FOUND error is returned.
//
//   - name: Immutable. Fully qualified name
//     `projects/{project}/locations/global/collections/{collection}/dataStore/*/c
//     onversations/*` or
//     `projects/{project}/locations/global/collections/{collection}/engines/*/con
//     versations/*`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Patch(name string, googleclouddiscoveryenginev1conversation *GoogleCloudDiscoveryengineV1Conversation) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1conversation = googleclouddiscoveryenginev1conversation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided Conversation to update. The following are NOT supported: *
// Conversation.name If not set or empty, all supported fields are updated.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1conversation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Conversation.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresModelsOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.models.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresModelsOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresModelsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.models.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresSchemasCreateCall struct {
	s                                  *Service
	parent                             string
	googleclouddiscoveryenginev1schema *GoogleCloudDiscoveryengineV1Schema
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Creates a Schema.
//
//   - parent: The parent data store resource name, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Create(parent string, googleclouddiscoveryenginev1schema *GoogleCloudDiscoveryengineV1Schema) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1schema = googleclouddiscoveryenginev1schema
	return c
}

// SchemaId sets the optional parameter "schemaId": Required. The ID to use for
// the Schema, which becomes the final component of the Schema.name. This field
// should conform to RFC-1034 (https://tools.ietf.org/html/rfc1034) standard
// with a length limit of 63 characters.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) SchemaId(schemaId string) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c.urlParams_.Set("schemaId", schemaId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1schema)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/schemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSchemasDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Schema.
//
//   - name: The full resource name of the schema, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/schemas/{schema}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Delete(name string) *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSchemasGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Schema.
//
//   - name: The full resource name of the schema, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/schemas/{schema}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Get(name string) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Schema.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Schema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Schema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSchemasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Schemas.
//
//   - parent: The parent data store resource name, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) List(parent string) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// Schemas to return. The service may return fewer than this value. If
// unspecified, at most 100 Schemas are returned. The maximum value is 1000;
// values above 1000 are set to 1000.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous SchemaService.ListSchemas call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// SchemaService.ListSchemas must match the call that provided the page token.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/schemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ListSchemasResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ListSchemasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ListSchemasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1ListSchemasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresSchemasPatchCall struct {
	s                                  *Service
	name                               string
	googleclouddiscoveryenginev1schema *GoogleCloudDiscoveryengineV1Schema
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Updates a Schema.
//
//   - name: Immutable. The full resource name of the schema, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/schemas/{schema}`. This field must be a UTF-8 encoded
//     string with a length limit of 1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Patch(name string, googleclouddiscoveryenginev1schema *GoogleCloudDiscoveryengineV1Schema) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1schema = googleclouddiscoveryenginev1schema
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// the Schema is not found, a new Schema is created. In this situation,
// `update_mask` is ignored.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1schema)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresSchemasOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresSchemasOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall struct {
	s                                              *Service
	servingConfig                                  string
	googleclouddiscoveryenginev1answerqueryrequest *GoogleCloudDiscoveryengineV1AnswerQueryRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Answer: Answer query method.
//
//   - servingConfig: The resource name of the Search serving config, such as
//     `projects/*/locations/global/collections/default_collection/engines/*/servi
//     ngConfigs/default_serving_config`, or
//     `projects/*/locations/global/collections/default_collection/dataStores/*/se
//     rvingConfigs/default_serving_config`. This field is used to identify the
//     serving configuration name, set of models used to make the search.
func (r *ProjectsLocationsCollectionsDataStoresServingConfigsService) Answer(servingConfig string, googleclouddiscoveryenginev1answerqueryrequest *GoogleCloudDiscoveryengineV1AnswerQueryRequest) *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall {
	c := &ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1answerqueryrequest = googleclouddiscoveryenginev1answerqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1answerqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+servingConfig}:answer")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.servingConfigs.answer" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1AnswerQueryResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsAnswerCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1AnswerQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1AnswerQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall struct {
	s                                            *Service
	servingConfig                                string
	googleclouddiscoveryenginev1recommendrequest *GoogleCloudDiscoveryengineV1RecommendRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Recommend: Makes a recommendation, which requires a contextual user event.
//
//   - servingConfig: Full resource name of a ServingConfig:
//     `projects/*/locations/global/collections/*/engines/*/servingConfigs/*`, or
//     `projects/*/locations/global/collections/*/dataStores/*/servingConfigs/*`
//     One default serving config is created along with your recommendation
//     engine creation. The engine ID is used as the ID of the default serving
//     config. For example, for Engine
//     `projects/*/locations/global/collections/*/engines/my-engine`, you can use
//     `projects/*/locations/global/collections/*/engines/my-engine/servingConfigs
//     /my-engine` for your RecommendationService.Recommend requests.
func (r *ProjectsLocationsCollectionsDataStoresServingConfigsService) Recommend(servingConfig string, googleclouddiscoveryenginev1recommendrequest *GoogleCloudDiscoveryengineV1RecommendRequest) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c := &ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1recommendrequest = googleclouddiscoveryenginev1recommendrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1recommendrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+servingConfig}:recommend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1RecommendResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1RecommendResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1RecommendResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall struct {
	s                                         *Service
	servingConfig                             string
	googleclouddiscoveryenginev1searchrequest *GoogleCloudDiscoveryengineV1SearchRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Search: Performs a search.
//
//   - servingConfig: The resource name of the Search serving config, such as
//     `projects/*/locations/global/collections/default_collection/engines/*/servi
//     ngConfigs/default_serving_config`, or
//     `projects/*/locations/global/collections/default_collection/dataStores/defa
//     ult_data_store/servingConfigs/default_serving_config`. This field is used
//     to identify the serving configuration name, set of models used to make the
//     search.
func (r *ProjectsLocationsCollectionsDataStoresServingConfigsService) Search(servingConfig string, googleclouddiscoveryenginev1searchrequest *GoogleCloudDiscoveryengineV1SearchRequest) *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall {
	c := &ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1searchrequest = googleclouddiscoveryenginev1searchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1searchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+servingConfig}:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.servingConfigs.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1SearchResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1SearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1SearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1SearchResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleclouddiscoveryenginev1searchrequest.PageToken = pt }(c.googleclouddiscoveryenginev1searchrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleclouddiscoveryenginev1searchrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsCollectionsDataStoresSessionsCreateCall struct {
	s                                   *Service
	parent                              string
	googleclouddiscoveryenginev1session *GoogleCloudDiscoveryengineV1Session
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates a Session. If the Session to create already exists, an
// ALREADY_EXISTS error is returned.
//
//   - parent: Full resource name of parent data store. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsDataStoresSessionsService) Create(parent string, googleclouddiscoveryenginev1session *GoogleCloudDiscoveryengineV1Session) *ProjectsLocationsCollectionsDataStoresSessionsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresSessionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1session = googleclouddiscoveryenginev1session
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSessionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSessionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSessionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSessionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1session)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sessions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.sessions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Session.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSessionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Session, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Session{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSessionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Session. If the Session to delete does not exist, a
// NOT_FOUND error is returned.
//
//   - name: The resource name of the Session to delete. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}/sessions/{session_id}`.
func (r *ProjectsLocationsCollectionsDataStoresSessionsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresSessionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.sessions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresSessionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSessionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Session.
//
//   - name: The resource name of the Session to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}/sessions/{session_id}`.
func (r *ProjectsLocationsCollectionsDataStoresSessionsService) Get(name string) *ProjectsLocationsCollectionsDataStoresSessionsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSessionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSessionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSessionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSessionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSessionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSessionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.sessions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Session.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSessionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Session, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Session{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSessionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Sessions by their parent DataStore.
//
//   - parent: The data store resource name. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsDataStoresSessionsService) List(parent string) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c := &ProjectsLocationsCollectionsDataStoresSessionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the list
// results. The supported features are: user_pseudo_id, state. Example:
// "user_pseudo_id = some_id"
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": A comma-separated list of
// fields to order by, sorted in ascending order. Use "desc" after a field name
// for descending. Supported fields: * `update_time` * `create_time` *
// `session_name` Example: "update_time desc" "create_time"
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) OrderBy(orderBy string) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. If unspecified, defaults to 50. Max allowed value is 1000.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListSessions` call. Provide this to retrieve the subsequent
// page.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSessionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sessions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.sessions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1ListSessionsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1ListSessionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1ListSessionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1ListSessionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCollectionsDataStoresSessionsPatchCall struct {
	s                                   *Service
	name                                string
	googleclouddiscoveryenginev1session *GoogleCloudDiscoveryengineV1Session
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a Session. Session action type cannot be changed. If the
// Session to update does not exist, a NOT_FOUND error is returned.
//
//   - name: Immutable. Fully qualified name
//     `projects/{project}/locations/global/collections/{collection}/engines/{engi
//     ne}/sessions/*`.
func (r *ProjectsLocationsCollectionsDataStoresSessionsService) Patch(name string, googleclouddiscoveryenginev1session *GoogleCloudDiscoveryengineV1Session) *ProjectsLocationsCollectionsDataStoresSessionsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresSessionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1session = googleclouddiscoveryenginev1session
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided Session to update. The following are NOT supported: *
// Session.name If not set or empty, all supported fields are updated.
func (c *ProjectsLocationsCollectionsDataStoresSessionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresSessionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSessionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSessionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSessionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSessionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1session)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.sessions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Session.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSessionsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Session, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Session{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Answer.
//
//   - name: The resource name of the Answer to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{collection}
//     /engines/{engine_id}/sessions/{session_id}/answers/{answer_id}`.
func (r *ProjectsLocationsCollectionsDataStoresSessionsAnswersService) Get(name string) *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.sessions.answers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDiscoveryengineV1Answer.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSessionsAnswersGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1Answer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1Answer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall struct {
	s                                                         *Service
	parent                                                    string
	googleclouddiscoveryenginev1batchverifytargetsitesrequest *GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// BatchVerifyTargetSites: Verify target sites' ownership and validity. This
// API sends all the target sites under site search engine for verification.
//
//   - parent: The parent resource shared by all TargetSites being verified.
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) BatchVerifyTargetSites(parent string, googleclouddiscoveryenginev1batchverifytargetsitesrequest *GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1batchverifytargetsitesrequest = googleclouddiscoveryenginev1batchverifytargetsitesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1batchverifytargetsitesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:batchVerifyTargetSites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.batchVerifyTargetSites" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall struct {
	s                                                            *Service
	siteSearchEngine                                             string
	googleclouddiscoveryenginev1disableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// DisableAdvancedSiteSearch: Downgrade from advanced site search to basic site
// search.
//
//   - siteSearchEngine: Full resource name of the SiteSearchEngine, such as
//     `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSea
//     rchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) DisableAdvancedSiteSearch(siteSearchEngine string, googleclouddiscoveryenginev1disableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	c.googleclouddiscoveryenginev1disableadvancedsitesearchrequest = googleclouddiscoveryenginev1disableadvancedsitesearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1disableadvancedsitesearchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+siteSearchEngine}:disableAdvancedSiteSearch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"siteSearchEngine": c.siteSearchEngine,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.disableAdvancedSiteSearch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall struct {
	s                                                           *Service
	siteSearchEngine                                            string
	googleclouddiscoveryenginev1enableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// EnableAdvancedSiteSearch: Upgrade from basic site search to advanced site
// search.
//
//   - siteSearchEngine: Full resource name of the SiteSearchEngine, such as
//     `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSea
//     rchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) EnableAdvancedSiteSearch(siteSearchEngine string, googleclouddiscoveryenginev1enableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	c.googleclouddiscoveryenginev1enableadvancedsitesearchrequest = googleclouddiscoveryenginev1enableadvancedsitesearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1enableadvancedsitesearchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+siteSearchEngine}:enableAdvancedSiteSearch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"siteSearchEngine": c.siteSearchEngine,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.enableAdvancedSiteSearch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall struct {
	s                *Service
	siteSearchEngine string
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// FetchDomainVerificationStatus: Returns list of target sites with its domain
// verification status. This method can only be called under data store with
// BASIC_SITE_SEARCH state at the moment.
//
//   - siteSearchEngine: The site search engine resource under which we fetch all
//     the domain verification status.
//     `projects/{project}/locations/{location}/collections/{collection}/dataStore
//     s/{data_store}/siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) FetchDomainVerificationStatus(siteSearchEngine string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default. The maximum value is 1000; values above 1000 will be
// coerced to 1000. If this field is negative, an INVALID_ARGUMENT error is
// returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `FetchDomainVerificationStatus` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `FetchDomainVerificationStatus` must match the call that provided the
// page token.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

//