/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class AquaPainter
extends BasicPainter {
    private static final Logger LOGGER = Logger.getLogger(AquaPainter.class.getName());
    private static AquaPainter _instance;
    private static final ImageIcon SELECTED;
    private static final ImageIcon ROLLOVER;
    private static final ImageIcon PRESSED;
    private static final Color ROLLOVER_BACKGROUND;
    private static final Color SELECTED_BACKGROUND;
    private static final Color PRESSED_BACKGROUND;
    private static boolean _errorOccurred;
    private static Color ACTIVE_TOP_GRADIENT_COLOR;
    private static Color ACTIVE_BOTTOM_GRADIENT_COLOR;
    private static Color INACTIVE_TOP_GRADIENT_COLOR;
    private static Color INACTIVE_BOTTOM_GRADIENT_COLOR;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new AquaPainter();
        }
        return _instance;
    }

    public Color getCommandBarTitleBarBackground() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    public void paintButtonBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (state == 0) {
            if (c.isOpaque() && c instanceof AbstractButton && ((AbstractButton)c).isContentAreaFilled()) {
                this.paintImageBorder(g2, rect, ROLLOVER, ROLLOVER_BACKGROUND);
            } else {
                super.paintButtonBackground(c, g2, rect, orientation, state);
            }
        } else if (state == 2) {
            this.paintImageBorder(g2, rect, ROLLOVER, ROLLOVER_BACKGROUND);
        } else if (state == 3) {
            this.paintImageBorder(g2, rect, SELECTED, SELECTED_BACKGROUND);
        } else if (state == 1) {
            this.paintImageBorder(g2, rect, PRESSED, PRESSED_BACKGROUND);
        }
    }

    private void paintImageBorder(Graphics g2, Rectangle rect, ImageIcon icon, Color background) {
        JideSwingUtilities.drawImageBorder(g2, icon, rect, new Insets(3, 3, 3, 3), false);
        if (background != null) {
            Color oldColor = g2.getColor();
            g2.setColor(background);
            g2.fillRect(rect.x + 3, rect.y + 3, rect.width - 6, rect.height - 6);
            g2.setColor(oldColor);
        }
    }

    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                this.drawFrameTitleBackground((Graphics2D)g2, rect.x, rect.y, rect.width, rect.height, true, false, false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(c, g2, rect, orientation, state);
    }

    public void paintCollapsiblePaneTitlePaneBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                this.drawFrameTitleBackground((Graphics2D)g2, rect.x, rect.y, rect.width, rect.height, false, false, false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintCollapsiblePaneTitlePaneBackground(c, g2, rect, orientation, state);
    }

    public void paintDockableFrameTitlePane(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                this.drawFrameTitleBackground((Graphics2D)g2, rect.x, rect.y, rect.width, rect.height, state == 3, false, false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintDockableFrameTitlePane(c, g2, rect, orientation, state);
    }

    public void paintCommandBarTitlePane(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                this.drawFrameTitleBackground((Graphics2D)g2, rect.x, rect.y, rect.width, rect.height, true, false, false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintCommandBarTitlePane(c, g2, rect, orientation, state);
    }

    private void drawFrameTitleBackground(Graphics2D g2, int x, int y, int w, int h2, boolean active, boolean c, boolean d) {
        Color topColor = active ? ACTIVE_TOP_GRADIENT_COLOR : INACTIVE_TOP_GRADIENT_COLOR;
        Color bottomColor = active ? ACTIVE_BOTTOM_GRADIENT_COLOR : INACTIVE_BOTTOM_GRADIENT_COLOR;
        JideSwingUtilities.fillGradient(g2, new Rectangle(x, y, w, h2), topColor, bottomColor, true);
    }

    static {
        SELECTED = IconsFactory.getImageIcon(AquaPainter.class, "icons/selected.gif");
        ROLLOVER = IconsFactory.getImageIcon(AquaPainter.class, "icons/rollover.gif");
        PRESSED = IconsFactory.getImageIcon(AquaPainter.class, "icons/pressed.gif");
        ROLLOVER_BACKGROUND = new Color(238, 238, 238);
        SELECTED_BACKGROUND = new Color(153, 153, 153);
        PRESSED_BACKGROUND = new Color(195, 195, 195);
        ACTIVE_TOP_GRADIENT_COLOR = new Color(0xBCBCBC);
        ACTIVE_BOTTOM_GRADIENT_COLOR = new Color(0x9A9A9A);
        INACTIVE_TOP_GRADIENT_COLOR = new Color(0xE4E4E4);
        INACTIVE_BOTTOM_GRADIENT_COLOR = new Color(0xD1D1D1);
    }
}

