/* XKey keyboard mapping for wscons keyboards.  Ace Husky 2024.
 *
 * Derived from bsd_KbdMap.c 
 *
 * Slightly modified xf86KbdBSD.c which is
 *
 * Derived from xf86Kbd.c by S_ren Schmidt (sos@login.dkuug.dk)
 * which is Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 * and from xf86KbdCODrv.c by Holger Veit
 */

#include "kkeymap.h"
#define XK_PUBLISHING
#include <X11/keysym.h>

static KeySym wsUsbMap[] = {
	/* 0 */ NoSymbol,
	/* 1 */ NoSymbol,
	/* 2 */ NoSymbol,
	/* 3 */ NoSymbol,
	/* 4 */ XK_A,		
	/* 5 */ XK_B,
	/* 6 */ XK_C,
	/* 7 */ XK_D,
	/* 8 */ XK_E,
	/* 9 */ XK_F,
	/* 10 */ XK_G,
	/* 11 */ XK_H,
	/* 12 */ XK_I,
	/* 13 */ XK_J,
	/* 14 */ XK_K,
	/* 15 */ XK_L,
	/* 16 */ XK_M,
	/* 17 */ XK_N,
	/* 18 */ XK_O,
	/* 19 */ XK_P,
	/* 20 */ XK_Q,
	/* 21 */ XK_R,
	/* 22 */ XK_S,
	/* 23 */ XK_T,
	/* 24 */ XK_U,
	/* 25 */ XK_V,
	/* 26 */ XK_W,
	/* 27 */ XK_X,
	/* 28 */ XK_Y,
	/* 29 */ XK_Z,
	/* 30 */ XK_1,		/* 1 !*/
	/* 31 */ XK_2,		/* 2 @ */
	/* 32 */ XK_3,		/* 3 # */
	/* 33 */ XK_4,		/* 4 $ */
	/* 34 */ XK_5,		/* 5 % */
	/* 35 */ XK_6,		/* 6 ^ */
	/* 36 */ XK_7,		/* 7 & */
	/* 37 */ XK_8,		/* 8 * */
	/* 38 */ XK_9,		/* 9 ( */
	/* 39 */ XK_0,		/* 0 ) */
	/* 40 */ XK_Return,	/* Return  */
	/* 41 */ XK_Escape,	/* Escape */
	/* 42 */ XK_BackSpace,	/* Backspace Delete */
	/* 43 */ XK_Tab,	/* Tab */
	/* 44 */ XK_space,	/* Space */
	/* 45 */ XK_minus,	/* - _ */
	/* 46 */ XK_equal,	/* = + */
	/* 47 */ XK_bracketleft,	/* [ { */
	/* 48 */ XK_bracketright,	/* ] } */
	/* 49 */ XK_backslash,	/* \ | */
	/* 50 */ XK_backslash,    /* \ _ # ~ on some keyboards */
	/* 51 */ XK_semicolon,	/* ; : */
	/* 52 */ XK_apostrophe,	/* ' " */
	/* 53 */ XK_grave,	/* ` ~ */
	/* 54 */ XK_comma,	/* , <  */
	/* 55 */ XK_period,	/* . > */
	/* 56 */ XK_slash,	/* / ? */
	/* 57 */ XK_Caps_Lock,	/* Caps Lock */
	/* 58 */ XK_F1,		/* F1 */
	/* 59 */ XK_F2,		/* F2 */
	/* 60 */ XK_F3,		/* F3 */
	/* 61 */ XK_F4,		/* F4 */
	/* 62 */ XK_F5,		/* F5 */
	/* 63 */ XK_F6,		/* F6 */
	/* 64 */ XK_F7,		/* F7 */
	/* 65 */ XK_F8,		/* F8 */
	/* 66 */ XK_F9,		/* F9 */
	/* 67 */ XK_F10,	/* F10 */
	/* 68 */ XK_F11,	/* F11 */
	/* 69 */ XK_F12,	/* F12 */
	/* 70 */ XK_Print,	/* PrintScrn SysReq */
	/* 71 */ XK_Scroll_Lock,	/* Scroll Lock */
	/* 72 */ XK_Break,	/* Break Break */
	/* 73 */ XK_Insert,	/* Insert XXX  Help on some Mac Keyboards */
	/* 74 */ XK_Home,	/* Home */
	/* 75 */ XK_Prior,	/* Page Up */
	/* 76 */ XK_Delete,	/* Delete */
	/* 77 */ XK_End,	/* End */
	/* 78 */ XK_Next,	/* Page Down */
	/* 79 */ XK_Right,	/* Right Arrow */
	/* 80 */ XK_Left,	/* Left Arrow */
	/* 81 */ XK_Down,	/* Down Arrow */
	/* 82 */ XK_Up,		/* Up Arrow */
	/* 83 */ XK_Num_Lock,	/* Num Lock */
	/* 84 */ XK_KP_Divide,	/* Keypad / */
	/* 85 */ XK_KP_Multiply, /* Keypad * */
	/* 86 */ XK_KP_Subtract,	/* Keypad - */
	/* 87 */ XK_KP_Add,	/* Keypad + */
	/* 88 */ XK_KP_Enter,	/* Keypad Enter */
	/* 89 */ XK_KP_1,	/* Keypad 1 End */
	/* 90 */ XK_KP_2,	/* Keypad 2 Down */
	/* 91 */ XK_KP_3,	/* Keypad 3 Pg Down */
	/* 92 */ XK_KP_4,	/* Keypad 4 Left  */
	/* 93 */ XK_KP_5,	/* Keypad 5 */
	/* 94 */ XK_KP_6,	/* Keypad 6 */
	/* 95 */ XK_KP_7,	/* Keypad 7 Home */
	/* 96 */ XK_KP_8,	/* Keypad 8 Up */
	/* 97 */ XK_KP_9,	/* KEypad 9 Pg Up */
	/* 98 */ XK_KP_0,	/* Keypad 0 Ins */
	/* 99 */ XK_KP_Decimal,	/* Keypad . Del */
	/* 100 */ XK_less,	/* < > on some keyboards */
	/* 101 */ XK_Menu,	/* Menu */
	/* 102 */ NoSymbol /* XK_Power */,	/* sleep key on Sun USB */
	/* 103 */ NoSymbol /* XK_KP_Equal */, /* Keypad = on Mac keyboards */
	/* 104 */ XK_F13,
	/* 105 */ XK_F14,
	/* 106 */ XK_F15,
	/* 107 */ XK_F16,
	/* 108 */ NoSymbol,
	/* 109 */ NoSymbol /* XK_Power */,
	/* 110 */ NoSymbol,
	/* 111 */ NoSymbol,
	/* 112 */ NoSymbol,
	/* 113 */ NoSymbol,
	/* 114 */ NoSymbol,
	/* 115 */ NoSymbol,
	/* 116 */ XK_F7,
	/* 117 */ XK_Help,
	/* 118 */ XK_F3,
	/* 119 */ XK_F5,
	/* 120 */ XK_F1,
	/* 121 */ XK_F2,
	/* 122 */ XK_F4,
	/* 123 */ XK_F10,
	/* 124 */ XK_F6,
	/* 125 */ XK_F8,
	/* 126 */ XK_F9,
	/* 127 */ NoSymbol /* XK_Mute */,
	/* 128 */ NoSymbol /* XK_AudioRaise */,
	/* 129 */ NoSymbol /* XK_AudioLower */,
	/* 130 */ NoSymbol,
	/* 131 */ NoSymbol,
	/* 132 */ NoSymbol,
	/* 133 */ NoSymbol,
	/* 134 */ NoSymbol,
/*
 * Special keycodes for Japanese keyboards
 * Override atKeyname HKTG and backslash2 code to unique values for JP106 keyboards
 */
#undef XK_HKTG
#define XK_HKTG	200	/* Japanese Hiragana Katakana Toggle */
#undef XK_backslash2
#define XK_backslash2	203	/* Japanese '\_' key */

	/* 135 */ XK_backslash2,	/* Japanese 106 kbd: '\_' */
	/* 136 */ XK_HKTG,	/* Japanese 106 kbd: Hiragana Katakana toggle */
	/* 137 */ XK_yen,	/* Japanese 106 kbd: '\|' */
	/* 138 */ NoSymbol /* XK_XFER */,	/* Japanese 106 kbd: Henkan */
	/* 139 */ NoSymbol /* XK_NFER */,	/* Japanese 106 kbd: Muhenkan */
	/* 140 */ NoSymbol,
	/* 141 */ NoSymbol,
	/* 142 */ NoSymbol,
	/* 143 */ NoSymbol,
/*
 * Special keycodes for Korean keyboards
 * Define Hangul and Hangul_Hanja unique key codes
 * These keys also use KANA and EISU on some Macintosh Japanese USB keyboards
 */
	/* 144 */ XK_Hangul,		/* Korean 106 kbd: Hangul */
	/* 145 */ XK_Hangul_Hanja,	/* Korean 106 kbd: Hangul Hanja */
	/* 146 */ NoSymbol,
	/* 147 */ NoSymbol,
	/* 148 */ NoSymbol,
	/* 149 */ NoSymbol,
	/* 150 */ NoSymbol,
	/* 151 */ NoSymbol,
	/* 152 */ NoSymbol,
	/* 153 */ NoSymbol,
	/* 154 */ NoSymbol,
	/* 155 */ NoSymbol,
	/* 156 */ NoSymbol,
	/* 157 */ NoSymbol,
	/* 158 */ NoSymbol,
	/* 159 */ NoSymbol,
	/* 160 */ NoSymbol,
	/* 161 */ NoSymbol,
	/* 162 */ NoSymbol,
	/* 163 */ NoSymbol,
	/* 164 */ NoSymbol,
	/* 165 */ NoSymbol,
	/* 166 */ NoSymbol,
	/* 167 */ NoSymbol,
	/* 168 */ NoSymbol,
	/* 169 */ NoSymbol,
	/* 170 */ NoSymbol,
	/* 171 */ NoSymbol,
	/* 172 */ NoSymbol,
	/* 173 */ NoSymbol,
	/* 174 */ NoSymbol,
	/* 175 */ NoSymbol,
	/* 176 */ NoSymbol,
	/* 177 */ NoSymbol,
	/* 178 */ NoSymbol,
	/* 179 */ NoSymbol,
	/* 180 */ NoSymbol,
	/* 181 */ NoSymbol,
	/* 182 */ NoSymbol,
	/* 183 */ NoSymbol,
	/* 184 */ NoSymbol,
	/* 185 */ NoSymbol,
	/* 186 */ NoSymbol,
	/* 187 */ NoSymbol,
	/* 188 */ NoSymbol,
	/* 189 */ NoSymbol,
	/* 190 */ NoSymbol,
	/* 191 */ NoSymbol,
	/* 192 */ NoSymbol,
	/* 193 */ NoSymbol,
	/* 194 */ NoSymbol,
	/* 195 */ NoSymbol,
	/* 196 */ NoSymbol,
	/* 197 */ NoSymbol,
	/* 198 */ NoSymbol,
	/* 199 */ NoSymbol,
	/* 200 */ NoSymbol,
	/* 201 */ NoSymbol,
	/* 202 */ NoSymbol,
	/* 203 */ NoSymbol,
	/* 204 */ NoSymbol,
	/* 205 */ NoSymbol,
	/* 206 */ NoSymbol,
	/* 207 */ NoSymbol,
	/* 208 */ NoSymbol,
	/* 209 */ NoSymbol,
	/* 210 */ NoSymbol,
	/* 211 */ NoSymbol,
	/* 212 */ NoSymbol,
	/* 213 */ NoSymbol,
	/* 214 */ NoSymbol,
	/* 215 */ NoSymbol,
	/* 216 */ NoSymbol,
	/* 217 */ NoSymbol,
	/* 218 */ NoSymbol,
	/* 219 */ NoSymbol,
	/* 220 */ NoSymbol,
	/* 221 */ NoSymbol,
	/* 222 */ NoSymbol,
	/* 223 */ NoSymbol,
	/* 224 */ XK_Control_L,	/* Left Control */
	/* 225 */ XK_Shift_L,	/* Left Shift */
	/* 226 */ XK_Alt_L,	/* Left Alt */
	/* 227 */ NoSymbol /* XK_LMeta */,	/* Left Meta */
	/* 228 */ XK_Control_R,	/* Right Control */
	/* 229 */ XK_Shift_R,	/* Right Shift */
	/* 230 */ XK_Alt_R,	/* Right Alt, AKA AltGr */
	/* 231 */ XK_Meta_R,	/* Right Meta */
};

static KeySym wsXtMap[] = {
	/* 0 */ NoSymbol,
	/* 1 */ XK_Escape,
	/* 2 */ XK_1,
	/* 3 */ XK_2,
	/* 4 */ XK_3,
	/* 5 */ XK_4,
	/* 6 */ XK_5,
	/* 7 */ XK_6,
	/* 8 */ XK_7,
	/* 9 */ XK_8,
	/* 10 */ XK_9,
	/* 11 */ XK_0,
	/* 12 */ XK_minus,
	/* 13 */ XK_equal,
	/* 14 */ XK_BackSpace,
	/* 15 */ XK_Tab,
	/* 16 */ XK_Q,
	/* 17 */ XK_W,
	/* 18 */ XK_E,
	/* 19 */ XK_R,
	/* 20 */ XK_T,
	/* 21 */ XK_Y,
	/* 22 */ XK_U,
	/* 23 */ XK_I,
	/* 24 */ XK_O,
	/* 25 */ XK_P,
	/* 26 */ XK_bracketleft,
	/* 27 */ XK_bracketright,
	/* 28 */ XK_Return,
	/* 29 */ XK_Control_L,
	/* 30 */ XK_A,
	/* 31 */ XK_S,
	/* 32 */ XK_D,
	/* 33 */ XK_F,
	/* 34 */ XK_G,
	/* 35 */ XK_H,
	/* 36 */ XK_J,
	/* 37 */ XK_K,
	/* 38 */ XK_L,
	/* 39 */ XK_semicolon,
	/* 40 */ XK_apostrophe,
	/* 41 */ XK_grave,
	/* 42 */ XK_Shift_L,
	/* 43 */ XK_backslash,
	/* 44 */ XK_Z,
	/* 45 */ XK_X,
	/* 46 */ XK_C,
	/* 47 */ XK_V,
	/* 48 */ XK_B,
	/* 49 */ XK_N,
	/* 50 */ XK_M,
	/* 51 */ XK_comma,
	/* 52 */ XK_period,
	/* 53 */ XK_slash,
	/* 54 */ XK_Shift_R,
	/* 55 */ XK_KP_Multiply,
	/* 56 */ XK_Alt_L,
	/* 57 */ XK_space,
	/* 58 */ XK_Caps_Lock,
	/* 59 */ XK_F1,
	/* 60 */ XK_F2,
	/* 61 */ XK_F3,
	/* 62 */ XK_F4,
	/* 63 */ XK_F5,
	/* 64 */ XK_F6,
	/* 65 */ XK_F7,
	/* 66 */ XK_F8,
	/* 67 */ XK_F9,
	/* 68 */ XK_F10,
	/* 69 */ XK_Num_Lock,
	/* 70 */ XK_Scroll_Lock,
	/* 71 */ XK_KP_7,
	/* 72 */ XK_KP_8,
	/* 73 */ XK_KP_9,
	/* 74 */ XK_KP_Subtract,
	/* 75 */ XK_KP_4,
	/* 76 */ XK_KP_5,
	/* 77 */ XK_KP_6,
	/* 78 */ XK_KP_Add,
	/* 79 */ XK_KP_1,
	/* 80 */ XK_KP_2,
	/* 81 */ XK_KP_3,
	/* 82 */ XK_KP_0,
	/* 83 */ XK_KP_Decimal,
	/* 84 */ NoSymbol,
	/* 85 */ NoSymbol,
	/* 86 */ XK_less,	/* backslash on uk, < on german */
	/* 87 */ XK_F11,
	/* 88 */ XK_F12,
	/* 89 */ NoSymbol,
	/* 90 */ NoSymbol,
	/* 91 */ NoSymbol,
	/* 92 */ NoSymbol,
	/* 93 */ NoSymbol,
	/* 94 */ NoSymbol,
	/* 95 */ NoSymbol,
	/* 96 */ NoSymbol,
	/* 97 */ NoSymbol,
	/* 98 */ NoSymbol,
	/* 99 */ NoSymbol,
	/* 100 */ NoSymbol,
	/* 101 */ NoSymbol,
	/* 102 */ NoSymbol,
	/* 103 */ NoSymbol,
	/* 104 */ NoSymbol,
	/* 105 */ NoSymbol,
	/* 106 */ NoSymbol,
	/* 107 */ NoSymbol,
	/* 108 */ NoSymbol,
	/* 109 */ NoSymbol,
	/* 110 */ NoSymbol,
	/* 111 */ NoSymbol,
	/* 112 */ XK_HKTG,
	/* 113 */ NoSymbol,
	/* 114 */ NoSymbol,
	/* 115 */ XK_backslash2,
	/* 116 */ NoSymbol,
	/* 117 */ NoSymbol,
	/* 118 */ NoSymbol,
	/* 119 */ NoSymbol,
	/* 120 */ NoSymbol,
	/* 121 */ NoSymbol /* XK_XFER */,
	/* 122 */ NoSymbol,
	/* 123 */ NoSymbol /* XK_NFER */,
	/* 124 */ NoSymbol,
	/* 125 */ XK_yen,
	/* 126 */ NoSymbol,
	/* 127 */ XK_Break,
	/* 128 */ NoSymbol,
	/* 129 */ NoSymbol,
	/* 130 */ NoSymbol,
	/* 131 */ NoSymbol,
	/* 132 */ NoSymbol,
	/* 133 */ NoSymbol,
	/* 134 */ NoSymbol,
	/* 135 */ NoSymbol,
	/* 136 */ NoSymbol,
	/* 137 */ NoSymbol,
	/* 138 */ NoSymbol,
	/* 139 */ NoSymbol,
	/* 140 */ NoSymbol,
	/* 141 */ NoSymbol,
	/* 142 */ NoSymbol,
	/* 143 */ NoSymbol,
	/* 144 */ NoSymbol,
	/* 145 */ NoSymbol,
	/* 146 */ NoSymbol,
	/* 147 */ NoSymbol,
	/* 148 */ NoSymbol,
	/* 149 */ NoSymbol,
	/* 150 */ NoSymbol,
	/* 151 */ NoSymbol,
	/* 152 */ NoSymbol,
	/* 153 */ NoSymbol,
	/* 154 */ NoSymbol,
	/* 155 */ NoSymbol,
	/* 156 */ XK_KP_Enter,
	/* 157 */ XK_Control_R,
	/* 158 */ NoSymbol,
	/* 159 */ NoSymbol,
	/* 160 */ NoSymbol /* XK_Mute */,
	/* 161 */ NoSymbol,
	/* 162 */ NoSymbol,
	/* 163 */ NoSymbol,
	/* 164 */ NoSymbol,
	/* 165 */ NoSymbol,
	/* 166 */ NoSymbol,
	/* 167 */ NoSymbol,
	/* 168 */ NoSymbol,
	/* 169 */ NoSymbol,
	/* 170 */ XK_Print,
	/* 171 */ NoSymbol,
	/* 172 */ NoSymbol,
	/* 173 */ NoSymbol,
	/* 174 */ NoSymbol /* XK_AudioLower */,
	/* 175 */ NoSymbol /* XK_AudioRaise */,
	/* 176 */ NoSymbol,
	/* 177 */ NoSymbol,
	/* 178 */ NoSymbol,
	/* 179 */ NoSymbol,
	/* 180 */ NoSymbol,
	/* 181 */ XK_KP_Divide,
	/* 182 */ NoSymbol,
	/* 183 */ XK_Print,
	/* 184 */ XK_Alt_R,
	/* 185 */ NoSymbol,
	/* 186 */ NoSymbol,
	/* 187 */ NoSymbol,
	/* 188 */ NoSymbol,
	/* 189 */ NoSymbol,
	/* 190 */ NoSymbol,
	/* 191 */ NoSymbol,
	/* 192 */ NoSymbol,
	/* 193 */ NoSymbol,
	/* 194 */ NoSymbol,
	/* 195 */ NoSymbol,
	/* 196 */ NoSymbol,
	/* 197 */ NoSymbol,
	/* 198 */ NoSymbol,
	/* 199 */ XK_Home,
	/* 200 */ XK_Up,
	/* 201 */ XK_Prior,
	/* 202 */ NoSymbol,
	/* 203 */ XK_Left,
	/* 204 */ NoSymbol,
	/* 205 */ XK_Right,
	/* 206 */ NoSymbol,
	/* 207 */ XK_End,
	/* 208 */ XK_Down,
	/* 209 */ XK_Next,
	/* 210 */ XK_Insert,
	/* 211 */ XK_Delete,
	/* 212 */ NoSymbol,
	/* 213 */ NoSymbol,
	/* 214 */ NoSymbol,
	/* 215 */ NoSymbol,
	/* 216 */ NoSymbol,
	/* 217 */ NoSymbol,
	/* 218 */ NoSymbol,
	/* 219 */ NoSymbol /* XK_LMeta */,
	/* 220 */ NoSymbol /*XK_RMeta */,
	/* 221 */ XK_Menu,
};

/* Map for adb keyboards  */
static KeySym wsAdbMap[] = {
	/* 0 */ XK_A,
	/* 1 */ XK_S,
	/* 2 */ XK_D,
	/* 3 */ XK_F,
	/* 4 */ XK_H,
	/* 5 */ XK_G,
	/* 6 */ XK_Z,
	/* 7 */ XK_X,
	/* 8 */ XK_C,
	/* 9 */ XK_V,
	/* 10 */ NoSymbol,	/* @ # on french keyboards */
	/* 11 */ XK_B,
	/* 12 */ XK_Q,
	/* 13 */ XK_W,
	/* 14 */ XK_E,
	/* 15 */ XK_R,
	/* 16 */ XK_Y,
	/* 17 */ XK_T,
	/* 18 */ XK_1,
	/* 19 */ XK_2,
	/* 20 */ XK_3,
	/* 21 */ XK_4,
	/* 22 */ XK_6,
	/* 23 */ XK_5,
	/* 24 */ XK_equal,
	/* 25 */ XK_9,
	/* 26 */ XK_7,
	/* 27 */ XK_minus,
	/* 28 */ XK_8,
	/* 29 */ XK_0,
	/* 30 */ XK_bracketright,
	/* 31 */ XK_O,
	/* 32 */ XK_U,
	/* 33 */ XK_bracketleft,
	/* 34 */ XK_I,
	/* 35 */ XK_P,
	/* 36 */ XK_Return,
	/* 37 */ XK_L,
	/* 38 */ XK_J,
	/* 39 */ XK_apostrophe,
	/* 40 */ XK_K,
	/* 41 */ XK_semicolon,
	/* 42 */ XK_backslash,
	/* 43 */ XK_comma,
	/* 44 */ XK_slash,
	/* 45 */ XK_N,
	/* 46 */ XK_M,
	/* 47 */ XK_period,
	/* 48 */ XK_Tab,
	/* 49 */ XK_space,
	/* 50 */ XK_grave,
	/* 51 */ XK_BackSpace,
	/* 52 */ XK_Alt_R,
	/* 53 */ XK_Escape,
	/* 54 */ XK_Control_L,
	/* 55 */ XK_Super_L,
	/* 56 */ XK_Shift_L,
	/* 57 */ XK_Caps_Lock,
	/* 58 */ XK_Alt_L,
	/* 59 */ XK_Left,
	/* 60 */ XK_Right,
	/* 61 */ XK_Down,
	/* 62 */ XK_Up,
	/* 63 */ NoSymbol,	/* Fn */
	/* 64 */ NoSymbol,
	/* 65 */ XK_KP_Decimal,
	/* 66 */ NoSymbol,
	/* 67 */ XK_KP_Multiply,
	/* 68 */ NoSymbol,
	/* 69 */ XK_KP_Add,
	/* 70 */ NoSymbol,
	/* 71 */ XK_Num_Lock,	/* Clear */
	/* 72 */ NoSymbol, 
	/* 73 */ NoSymbol,
	/* 74 */ NoSymbol,
	/* 75 */ XK_KP_Divide,
	/* 76 */ XK_KP_Enter,
	/* 77 */ NoSymbol,
	/* 78 */ XK_KP_Subtract,
	/* 79 */ NoSymbol,
	/* 80 */ NoSymbol,
	/* 81 */ NoSymbol /* XK_KP_Equal */,	/* Keypad = */
	/* 82 */ XK_KP_0,
	/* 83 */ XK_KP_1,
	/* 84 */ XK_KP_2,
	/* 85 */ XK_KP_3,
	/* 86 */ XK_KP_4,
	/* 87 */ XK_KP_5,
	/* 88 */ XK_KP_6,
	/* 89 */ XK_KP_7,
	/* 90 */ NoSymbol,
	/* 91 */ XK_KP_8,
	/* 92 */ XK_KP_9,
	/* 93 */ NoSymbol,
	/* 94 */ NoSymbol,
	/* 95 */ XK_KP_Decimal,	/* Keypad ,  */
	/* 96 */ XK_F5,
	/* 97 */ XK_F6,
	/* 98 */ XK_F7,
	/* 99 */ XK_F3,
	/* 100 */ XK_F8,
	/* 101 */ XK_F9,
	/* 102 */ NoSymbol,
	/* 103 */ XK_F11,
	/* 104 */ NoSymbol,
	/* 105 */ XK_Print,
	/* 106 */ XK_KP_Enter,
	/* 107 */ XK_Scroll_Lock,
	/* 108 */ NoSymbol,
	/* 109 */ XK_F10,
	/* 110 */ NoSymbol,
	/* 111 */ XK_F12,
	/* 112 */ NoSymbol,
	/* 113 */ XK_Break,
	/* 114 */ XK_Insert,
	/* 115 */ XK_Home,
	/* 116 */ XK_Prior,
	/* 117 */ XK_Delete,
	/* 118 */ XK_F4,
	/* 119 */ XK_End,
	/* 120 */ XK_F2,
	/* 121 */ XK_Next,
	/* 122 */ XK_F1,
	/* 123 */ NoSymbol,
	/* 124 */ NoSymbol,
	/* 125 */ NoSymbol,
	/* 126 */ NoSymbol,
	/* 127 */ NoSymbol /* XK_Power */
};

/* Map for amiga keyboards  */
static KeySym wsAmigaMap[] = {
	/* 0 */ XK_grave,
	/* 1 */ XK_1,
	/* 2 */ XK_2,
	/* 3 */ XK_3,
	/* 4 */ XK_4,
	/* 5 */ XK_5,
	/* 6 */ XK_6,
	/* 7 */ XK_7,
	/* 8 */ XK_8,
	/* 9 */ XK_9,
	/* 10 */ XK_0,
	/* 11 */ XK_minus,
	/* 12 */ XK_equal,
	/* 13 */ XK_backslash,	/* key in this position only on Amiga */
	/* 14 */ NoSymbol,
	/* 15 */ XK_KP_0,
	/* 16 */ XK_Q,
	/* 17 */ XK_W,
	/* 18 */ XK_E,
	/* 19 */ XK_R,
	/* 20 */ XK_T,
	/* 21 */ XK_Y,
	/* 22 */ XK_U,
	/* 23 */ XK_I,
	/* 24 */ XK_O,
	/* 25 */ XK_P,
	/* 26 */ XK_bracketleft,
	/* 27 */ XK_bracketright,
	/* 28 */ NoSymbol,
	/* 29 */ XK_KP_1,
	/* 30 */ XK_KP_2,
	/* 31 */ XK_KP_3,
	/* 32 */ XK_A,
	/* 33 */ XK_S,
	/* 34 */ XK_D,
	/* 35 */ XK_F,
	/* 36 */ XK_G,
	/* 37 */ XK_H,
	/* 38 */ XK_J,
	/* 39 */ XK_K,
	/* 40 */ XK_L,
	/* 41 */ XK_semicolon,
	/* 42 */ XK_apostrophe,
	/* 43 */ XK_backslash,	/* # on international keyboards */
	/* 44 */ NoSymbol,
	/* 45 */ XK_KP_4,
	/* 46 */ XK_KP_5,
	/* 47 */ XK_KP_6,
	/* 48 */ XK_less,
	/* 49 */ XK_Z,
	/* 50 */ XK_X,
	/* 51 */ XK_C,
	/* 52 */ XK_V,
	/* 53 */ XK_B,
	/* 54 */ XK_N,
	/* 55 */ XK_M,
	/* 56 */ XK_comma,
	/* 57 */ XK_period,
	/* 58 */ XK_slash,
	/* 59 */ NoSymbol,
	/* 60 */ XK_KP_Decimal,
	/* 61 */ XK_KP_7,
	/* 62 */ XK_KP_8,
	/* 63 */ XK_KP_9,
	/* 64 */ XK_space,
	/* 65 */ XK_BackSpace,
	/* 66 */ XK_Tab,
	/* 67 */ XK_KP_Enter,
	/* 68 */ XK_Return,
	/* 69 */ XK_Escape,
	/* 70 */ XK_Delete,
	/* 71 */ NoSymbol,
	/* 72 */ NoSymbol, 
	/* 73 */ NoSymbol,
	/* 74 */ XK_KP_Subtract,
	/* 75 */ NoSymbol,
	/* 76 */ XK_Up,
	/* 77 */ XK_Down,
	/* 78 */ XK_Right,
	/* 79 */ XK_Left,
	/* 80 */ XK_F1,
	/* 81 */ XK_F2,
	/* 82 */ XK_F3,
	/* 83 */ XK_F4,
	/* 84 */ XK_F5,
	/* 85 */ XK_F6,
	/* 86 */ XK_F7,
	/* 87 */ XK_F8,
	/* 88 */ XK_F9,
	/* 89 */ XK_F10,
	/* 90 */ NoSymbol,		/* Keypad [ */
	/* 91 */ NoSymbol,		/* Keypad ] */
	/* 92 */ XK_KP_Divide,
	/* 93 */ XK_KP_Multiply,
	/* 94 */ XK_KP_Add,
	/* 95 */ XK_Help,
	/* 96 */ XK_Shift_L,
	/* 97 */ XK_Shift_R,
	/* 98 */ NoSymbol,
	/* 99 */ XK_Control_L,
	/* 100 */ XK_Alt_L,
	/* 101 */ XK_Alt_R,
	/* 102 */ NoSymbol /* XK_LMeta */,
	/* 103 */ NoSymbol /*XK_RMeta */
};

/* Map for LK201 keyboards  */
static KeySym wsLk201Map[] = {
	/* 0 */ XK_F1,
	/* 1 */ XK_F2,
	/* 2 */ XK_F3,
	/* 3 */ XK_F4,
	/* 4 */ XK_F5,
	/* 5 */ NoSymbol,
	/* 6 */ NoSymbol,
	/* 7 */ NoSymbol,
	/* 8 */ NoSymbol,
	/* 9 */ NoSymbol,
	/* 10 */ NoSymbol,
	/* 11 */ NoSymbol,
	/* 12 */ NoSymbol,
	/* 13 */ NoSymbol,
	/* 14 */ XK_F6,
	/* 15 */ XK_F7,
	/* 16 */ XK_F8,
	/* 17 */ XK_F9,
	/* 18 */ XK_F10,
	/* 19 */ NoSymbol,
	/* 20 */ NoSymbol,
	/* 21 */ NoSymbol,
	/* 22 */ NoSymbol,
	/* 23 */ NoSymbol,
	/* 24 */ NoSymbol,
	/* 25 */ NoSymbol,
	/* 26 */ NoSymbol,
	/* 27 */ XK_F11,
	/* 28 */ XK_F12,
	/* 29 */ XK_F13,
	/* 30 */ XK_F14,
	/* 31 */ NoSymbol,
	/* 32 */ NoSymbol,
	/* 33 */ NoSymbol,
	/* 34 */ NoSymbol,
	/* 35 */ NoSymbol,
	/* 36 */ NoSymbol,
	/* 37 */ NoSymbol,
	/* 38 */ XK_Help,
	/* 39 */ XK_F16,	/* Do */
	/* 40 */ NoSymbol,
	/* 41 */ NoSymbol,
	/* 42 */ XK_F17,
	/* 43 */ XK_F8,	/* F18 */
	/* 44 */ XK_F9,	/* F19 */
	/* 45 */ XK_F10,	/* F20 */
	/* 46 */ NoSymbol,
	/* 47 */ NoSymbol,
	/* 48 */ NoSymbol,
	/* 49 */ NoSymbol,
	/* 50 */ NoSymbol,
	/* 51 */ NoSymbol,
	/* 52 */ XK_Home,	/* Find */
	/* 53 */ XK_Insert,	/* Insert Here */
	/* 54 */ XK_Delete,	/* Re-move */
	/* 55 */ XK_End,	/* Select */
	/* 56 */ XK_Prior,	/* Prev-Screen */
	/* 57 */ XK_Next,	/* Next-Screen */
	/* 58 */ NoSymbol,
	/* 59 */ NoSymbol,
	/* 60 */ XK_KP_0,
	/* 61 */ NoSymbol,
	/* 62 */ XK_KP_Decimal,
	/* 63 */ XK_KP_Enter,
	/* 64 */ XK_KP_1,
	/* 65 */ XK_KP_2,
	/* 66 */ XK_KP_3,
	/* 67 */ XK_KP_4,
	/* 68 */ XK_KP_5,
	/* 69 */ XK_KP_6,
	/* 70 */ XK_KP_Add,	/* KP comma */
	/* 71 */ XK_KP_7,
	/* 72 */ XK_KP_8,
	/* 73 */ XK_KP_9,
	/* 74 */ XK_KP_Subtract,
	/* 75 */ XK_F1,	/* PF1 */
	/* 76 */ XK_F2,	/* PF2 */
	/* 77 */ XK_F3,	/* PF3 */
	/* 78 */ XK_F4,	/* PF4 */
	/* 79 */ NoSymbol,
	/* 80 */ NoSymbol,
	/* 81 */ XK_Left,
	/* 82 */ XK_Right,
	/* 83 */ XK_Down,
	/* 84 */ XK_Up,
	/* 85 */ NoSymbol,
	/* 86 */ NoSymbol,
	/* 87 */ NoSymbol,
	/* 88 */ XK_Shift_L,
	/* 89 */ XK_Control_L,
	/* 90 */ XK_Caps_Lock,
	/* 91 */ XK_Alt_L, 	/* Compose */
	/* 92 */ NoSymbol,
	/* 93 */ NoSymbol,
	/* 94 */ NoSymbol,
	/* 95 */ NoSymbol,
	/* 96 */ NoSymbol,
	/* 97 */ NoSymbol,
	/* 98 */ NoSymbol,
	/* 99 */ NoSymbol,
	/* 100 */ NoSymbol,
	/* 101 */ NoSymbol,
	/* 102 */ XK_Delete,
	/* 103 */ XK_Return,
	/* 104 */ XK_Tab,
	/* 105 */ XK_Escape, /* tilde */
	/* 106 */ XK_1,
	/* 107 */ XK_Q,
	/* 108 */ XK_A,
	/* 109 */ XK_Z,
	/* 110 */ NoSymbol,
	/* 111 */ XK_2,
	/* 112 */ XK_W,
	/* 113 */ XK_S,
	/* 114 */ XK_X,
	/* 115 */ XK_less,
	/* 116 */ NoSymbol,
	/* 117 */ XK_3,
	/* 118 */ XK_E,
	/* 119 */ XK_D,
	/* 120 */ XK_C,
	/* 121 */ NoSymbol,
	/* 122 */ XK_4,
	/* 123 */ XK_R,
	/* 124 */ XK_F,
	/* 125 */ XK_V,
	/* 126 */ XK_space,
	/* 127 */ NoSymbol,
	/* 128 */ XK_5,
	/* 129 */ XK_T,
	/* 130 */ XK_G,
	/* 131 */ XK_B,
	/* 132 */ NoSymbol,
	/* 133 */ XK_6,
	/* 134 */ XK_Y,
	/* 135 */ XK_H,
	/* 136 */ XK_N,
	/* 137 */ NoSymbol,
	/* 138 */ XK_7,
	/* 139 */ XK_U,
	/* 140 */ XK_J,
	/* 141 */ XK_M,
	/* 142 */ NoSymbol,
	/* 143 */ XK_8,
	/* 144 */ XK_I,
	/* 145 */ XK_K,
	/* 146 */ XK_comma,
	/* 147 */ NoSymbol,
	/* 148 */ XK_9,
	/* 149 */ XK_O,
	/* 150 */ XK_L,
	/* 151 */ XK_period,
	/* 152 */ NoSymbol,
	/* 153 */ XK_0,
	/* 154 */ XK_P,
	/* 155 */ NoSymbol,
	/* 156 */ XK_semicolon,
	/* 157 */ XK_slash,
	/* 158 */ NoSymbol,
	/* 159 */ XK_equal,
	/* 160 */ XK_bracketright,
	/* 161 */ XK_backslash,
	/* 162 */ NoSymbol,
	/* 163 */ XK_minus,
	/* 164 */ XK_bracketleft,
	/* 165 */ XK_apostrophe,
	/* 166 */ NoSymbol,
	/* 167 */ NoSymbol,
	/* 168 */ NoSymbol,
	/* 169 */ NoSymbol,
	/* 170 */ NoSymbol,
	/* 171 */ NoSymbol,
	/* 172 */ NoSymbol,
	/* 173 */ NoSymbol,
	/* 174 */ NoSymbol,
	/* 175 */ NoSymbol,
	/* 176 */ NoSymbol,
	/* 177 */ NoSymbol,
	/* 178 */ NoSymbol,
	/* 179 */ NoSymbol,
	/* 180 */ NoSymbol,
	/* 181 */ NoSymbol,
	/* 182 */ NoSymbol,
	/* 183 */ NoSymbol,
	/* 184 */ NoSymbol,
	/* 185 */ NoSymbol,
	/* 186 */ NoSymbol,
	/* 187 */ NoSymbol,
	/* 188 */ NoSymbol,
	/* 189 */ NoSymbol,
	/* 190 */ NoSymbol,
	/* 191 */ NoSymbol,
	/* 192 */ NoSymbol,
	/* 193 */ NoSymbol,
	/* 194 */ NoSymbol,
	/* 195 */ NoSymbol,
	/* 196 */ NoSymbol,
	/* 197 */ NoSymbol,
	/* 198 */ NoSymbol,
	/* 199 */ NoSymbol,
	/* 200 */ NoSymbol,
	/* 201 */ NoSymbol,
	/* 202 */ NoSymbol,
	/* 203 */ NoSymbol,
	/* 204 */ NoSymbol,
	/* 205 */ NoSymbol,
	/* 206 */ NoSymbol,
	/* 207 */ NoSymbol,
	/* 208 */ NoSymbol,
	/* 209 */ NoSymbol,
	/* 210 */ NoSymbol,
	/* 211 */ NoSymbol,
	/* 212 */ NoSymbol,
	/* 213 */ NoSymbol,
	/* 214 */ NoSymbol,
	/* 215 */ NoSymbol,
	/* 216 */ NoSymbol,
	/* 217 */ NoSymbol,
	/* 218 */ NoSymbol,
	/* 219 */ NoSymbol,
	/* 220 */ NoSymbol,
	/* 221 */ NoSymbol,
	/* 222 */ NoSymbol,
	/* 223 */ NoSymbol,
	/* 224 */ NoSymbol,
	/* 225 */ NoSymbol,
	/* 226 */ NoSymbol,
	/* 227 */ NoSymbol,
	/* 228 */ NoSymbol,
	/* 229 */ NoSymbol,
	/* 230 */ NoSymbol,
	/* 231 */ NoSymbol,
	/* 232 */ NoSymbol,
	/* 233 */ NoSymbol,
	/* 234 */ NoSymbol,
	/* 235 */ NoSymbol,
	/* 236 */ NoSymbol,
	/* 237 */ NoSymbol,
	/* 238 */ NoSymbol,
	/* 239 */ NoSymbol,
	/* 240 */ NoSymbol,
	/* 241 */ NoSymbol,
	/* 242 */ NoSymbol,
	/* 243 */ NoSymbol,
	/* 244 */ NoSymbol,
	/* 245 */ NoSymbol,
	/* 246 */ NoSymbol,
	/* 247 */ NoSymbol,
	/* 248 */ NoSymbol,
	/* 249 */ NoSymbol,
	/* 250 */ NoSymbol,
	/* 251 */ NoSymbol,
};

static KeySym wsSunMap[] = {
	/* 0x00 */ XK_Help,
	/* 0x01 */ XK_F1,		/* stop */
	/* 0x02 */ NoSymbol /* XK_AudioLower */,	/* BrightnessDown / S-VolumeDown */
	/* 0x03 */ XK_F2,		/* again */
	/* 0x04 */ NoSymbol /* XK_AudioRaise */,	/* BrightnessUp / S-VolumeUp */
	/* 0x05 */ XK_F1,
	/* 0x06 */ XK_F2,
	/* 0x07 */ XK_F10,
	/* 0x08 */ XK_F3,
	/* 0x09 */ XK_F11,
	/* 0x0a */ XK_F4,
	/* 0x0b */ XK_F12,
	/* 0x0c */ XK_F5,
	/* 0x0d */ XK_Alt_R,
	/* 0x0e */ XK_F6,
	/* 0x0f */ NoSymbol,
	/* 0x10 */ XK_F7,
	/* 0x11 */ XK_F8,
	/* 0x12 */ XK_F9,
	/* 0x13 */ XK_Alt_L,
	/* 0x14 */ XK_Up,
	/* 0x15 */ XK_Break,
	/* 0x16 */ XK_Print,
	/* 0x17 */ XK_Scroll_Lock,
	/* 0x18 */ XK_Left,
	/* 0x19 */ XK_F3,		/* props */
	/* 0x1a */ XK_F4,		/* undo */
	/* 0x1b */ XK_Down,
	/* 0x1c */ XK_Right,
	/* 0x1d */ XK_Escape,
	/* 0x1e */ XK_1,
	/* 0x1f */ XK_2,
	/* 0x20 */ XK_3,
	/* 0x21 */ XK_4,
	/* 0x22 */ XK_5,
	/* 0x23 */ XK_6,
	/* 0x24 */ XK_7,
	/* 0x25 */ XK_8,
	/* 0x26 */ XK_9,
	/* 0x27 */ XK_0,
	/* 0x28 */ XK_minus,
	/* 0x29 */ XK_equal,
	/* 0x2a */ XK_grave,
	/* 0x2b */ XK_BackSpace,
	/* 0x2c */ XK_Insert,
	/* 0x2d */ NoSymbol /* XK_Mute */,		/* Audio Mute */
	/* 0x2e */ XK_KP_Divide,
	/* 0x2f */ XK_KP_Multiply,
	/* 0x30 */ NoSymbol /* XK_Power */,
	/* 0x31 */ XK_F5,		/* front */
	/* 0x32 */ XK_KP_Decimal,
	/* 0x33 */ XK_F6,		/* copy */
	/* 0x34 */ XK_Home,
	/* 0x35 */ XK_Tab,
	/* 0x36 */ XK_Q,
	/* 0x37 */ XK_W,
	/* 0x38 */ XK_E,
	/* 0x39 */ XK_R,
	/* 0x3a */ XK_T,
	/* 0x3b */ XK_Y,
	/* 0x3c */ XK_U,
	/* 0x3d */ XK_I,
	/* 0x3e */ XK_O,
	/* 0x3f */ XK_P,
	/* 0x40 */ XK_bracketleft,
	/* 0x41 */ XK_bracketright,
	/* 0x42 */ XK_Delete,
	/* 0x43 */ XK_Menu,		/* compose */
	/* 0x44 */ XK_KP_7,
	/* 0x45 */ XK_KP_8,
	/* 0x46 */ XK_KP_9,
	/* 0x47 */ XK_KP_Subtract,
	/* 0x48 */ XK_F7,		/* open */
	/* 0x49 */ XK_F8,		/* paste */
	/* 0x4a */ XK_End,
	/* 0x4b */ NoSymbol,
	/* 0x4c */ XK_Control_L,
	/* 0x4d */ XK_A,
	/* 0x4e */ XK_S,
	/* 0x4f */ XK_D,
	/* 0x50 */ XK_F,
	/* 0x51 */ XK_G,
	/* 0x52 */ XK_H,
	/* 0x53 */ XK_J,
	/* 0x54 */ XK_K,
	/* 0x55 */ XK_L,
	/* 0x56 */ XK_semicolon,
	/* 0x57 */ XK_apostrophe,
	/* 0x58 */ XK_backslash,
	/* 0x59 */ XK_Return,
	/* 0x5a */ XK_KP_Enter,
	/* 0x5b */ XK_KP_4,
	/* 0x5c */ XK_KP_5,
	/* 0x5d */ XK_KP_6,
	/* 0x5e */ XK_KP_0,
	/* 0x5f */ XK_F9,		/* find */
	/* 0x60 */ XK_Prior,
	/* 0x61 */ XK_F10,		/* cut */
	/* 0x62 */ XK_Num_Lock,
	/* 0x63 */ XK_Shift_L,
	/* 0x64 */ XK_Z,
	/* 0x65 */ XK_X,
	/* 0x66 */ XK_C,
	/* 0x67 */ XK_V,
	/* 0x68 */ XK_B,
	/* 0x69 */ XK_N,
	/* 0x6a */ XK_M,
	/* 0x6b */ XK_comma,
	/* 0x6c */ XK_period,
	/* 0x6d */ XK_slash,
	/* 0x6e */ XK_Shift_R,
	/* 0x6f */ NoSymbol,		/* linefeed */
	/* 0x70 */ XK_KP_1,
	/* 0x71 */ XK_KP_2,
	/* 0x72 */ XK_KP_3,
	/* 0x73 */ NoSymbol,
	/* 0x74 */ NoSymbol,
	/* 0x75 */ NoSymbol,
	/* 0x76 */ XK_Help,		/* help */
	/* 0x77 */ XK_Caps_Lock,
	/* 0x78 */ NoSymbol /* XK_LMeta */,
	/* 0x79 */ XK_space,
	/* 0x7a */ NoSymbol /*XK_RMeta */,
	/* 0x7b */ XK_Next,
	/* 0x7c */ XK_less,		/* < > on some keyboards */
	/* 0x7d */ XK_KP_Add,
	/* 0x7e */ NoSymbol,
	/* 0x7f */ NoSymbol
};
